/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.strimzi.api.kafka.model.AbstractCrdIT;
import io.strimzi.api.kafka.model.KafkaTopic;
import io.strimzi.test.k8s.exceptions.KubeClusterException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class KafkaTopicCrdIT
extends AbstractCrdIT {
    public static final String NAMESPACE = "topiccrd-it";

    @Test
    void testKafkaTopicV1alpha1() {
        this.assumeKube1_11Plus();
        this.createDelete(KafkaTopic.class, "KafkaTopicV1alpha1.yaml");
    }

    @Test
    void testKafkaTopicV1beta1() {
        this.createDelete(KafkaTopic.class, "KafkaTopicV1beta1.yaml");
    }

    @Test
    void testKafkaTopicMinimal() {
        this.createDelete(KafkaTopic.class, "KafkaTopic-minimal.yaml");
    }

    @Test
    void testKafkaTopicWithExtraProperty() {
        this.createDelete(KafkaTopic.class, "KafkaTopic-with-extra-property.yaml");
    }

    @Test
    void testKafkaTopicWithMissingProperty() {
        Throwable exception = Assertions.assertThrows(KubeClusterException.InvalidResource.class, () -> this.createDelete(KafkaTopic.class, "KafkaTopic-with-missing-required-property.yaml"));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.anyOf((Matcher)Matchers.allOf((Matcher)Matchers.containsStringIgnoringCase((String)"spec.partitions in body is required"), (Matcher)Matchers.containsStringIgnoringCase((String)"spec.replicas in body is required")), (Matcher)Matchers.allOf((Matcher)Matchers.containsStringIgnoringCase((String)"spec.partitions: Required value"), (Matcher)Matchers.containsStringIgnoringCase((String)"spec.replicas: Required value"))));
    }

    @BeforeAll
    void setupEnvironment() {
        this.cluster.createNamespace(NAMESPACE);
        this.cluster.createCustomResources(new String[]{"../install/cluster-operator/043-Crd-kafkatopic.yaml"});
    }

    @AfterAll
    void teardownEnvironment() {
        this.cluster.deleteCustomResources();
        this.cluster.deleteNamespaces();
    }
}

