/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.strimzi.api.kafka.model.AbstractCrdIT;
import io.strimzi.api.kafka.model.KafkaMirrorMaker;
import io.strimzi.test.k8s.exceptions.KubeClusterException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class KafkaMirrorMakerCrdIT
extends AbstractCrdIT {
    public static final String NAMESPACE = "kafkamirrormaker-crd-it";

    @Test
    void testKafkaMirrorMakerV1alpha1() {
        this.assumeKube1_11Plus();
        this.createDelete(KafkaMirrorMaker.class, "KafkaMirrorMakerV1alpha1.yaml");
    }

    @Test
    void testKafkaMirrorMakerV1beta1() {
        this.createDelete(KafkaMirrorMaker.class, "KafkaMirrorMakerV1beta1.yaml");
    }

    @Test
    void testKafkaMirrorMakerMinimal() {
        this.createDelete(KafkaMirrorMaker.class, "KafkaMirrorMaker-minimal.yaml");
    }

    @Test
    void testKafkaMirrorMakerWithExtraProperty() {
        this.createDelete(KafkaMirrorMaker.class, "KafkaMirrorMaker-with-extra-property.yaml");
    }

    @Test
    void testKafkaMirrorMakerWithMissingRequired() {
        Throwable exception = Assertions.assertThrows(KubeClusterException.InvalidResource.class, () -> this.createDelete(KafkaMirrorMaker.class, "KafkaMirrorMaker-with-missing-required-property.yaml"));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsStringIgnoringCase((String)"spec.consumer.bootstrapServers in body is required"), CoreMatchers.containsStringIgnoringCase((String)"spec.producer in body is required"), CoreMatchers.containsStringIgnoringCase((String)"spec.whitelist in body is required")}), CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsStringIgnoringCase((String)"spec.consumer.bootstrapServers: Required value"), CoreMatchers.containsStringIgnoringCase((String)"spec.whitelist: Required value"), CoreMatchers.containsStringIgnoringCase((String)"spec.producer: Required value")})}));
    }

    @Test
    void testKafkaMirrorMakerWithTls() {
        this.createDelete(KafkaMirrorMaker.class, "KafkaMirrorMaker-with-tls.yaml");
    }

    @Test
    void testKafkaMirrorMakerWithTlsAuth() {
        this.createDelete(KafkaMirrorMaker.class, "KafkaMirrorMaker-with-tls-auth.yaml");
    }

    @Test
    void testKafkaMirrorMakerWithTlsAuthWithMissingRequired() {
        Throwable exception = Assertions.assertThrows(KubeClusterException.InvalidResource.class, () -> this.createDelete(KafkaMirrorMaker.class, "KafkaMirrorMaker-with-tls-auth-with-missing-required.yaml"));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsStringIgnoringCase((String)"spec.producer.authentication.certificateAndKey.certificate in body is required"), CoreMatchers.containsStringIgnoringCase((String)"spec.producer.authentication.certificateAndKey.key in body is required")}), CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsStringIgnoringCase((String)"spec.producer.authentication.certificateAndKey.certificate: Required value"), CoreMatchers.containsStringIgnoringCase((String)"spec.producer.authentication.certificateAndKey.key: Required value"), CoreMatchers.containsStringIgnoringCase((String)"spec.whitelist: Required value")})}));
    }

    @Test
    void testKafkaMirrorMakerWithScramSha512Auth() {
        this.createDelete(KafkaMirrorMaker.class, "KafkaMirrorMaker-with-scram-sha-512-auth.yaml");
    }

    @Test
    void testKafkaMirrorMakerWithTemplate() {
        this.createDelete(KafkaMirrorMaker.class, "KafkaMirrorMaker-with-template.yaml");
    }

    @Test
    void testKafkaMirrorMakerWithCommitAndAbort() {
        this.createDelete(KafkaMirrorMaker.class, "KafkaMirrorMaker-with-commit-and-abort.yaml");
    }

    @BeforeAll
    void setupEnvironment() {
        this.cluster.createNamespace(NAMESPACE);
        this.cluster.createCustomResources(new String[]{"../install/cluster-operator/045-Crd-kafkamirrormaker.yaml"});
    }

    @AfterAll
    void teardownEnvironment() {
        this.cluster.deleteCustomResources();
        this.cluster.deleteNamespaces();
    }
}

