/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.strimzi.api.kafka.model.AbstractCrdIT;
import io.strimzi.api.kafka.model.Kafka;
import io.strimzi.test.k8s.exceptions.KubeClusterException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledIfEnvironmentVariable;

@DisabledIfEnvironmentVariable(named="TRAVIS", matches="true")
public class KafkaCrdIT
extends AbstractCrdIT {
    public static final String NAMESPACE = "kafkacrd-it";

    @Test
    void testKafkaV1alpha1() {
        this.assumeKube1_11Plus();
        this.createDelete(Kafka.class, "KafkaV1alpha1.yaml");
    }

    @Test
    void testKafkaV1Beta1() {
        this.createDelete(Kafka.class, "KafkaV1beta1.yaml");
    }

    @Test
    void testKafkaMinimal() {
        this.createDelete(Kafka.class, "Kafka-minimal.yaml");
    }

    @Test
    void testKafkaWithExtraProperty() {
        this.createDelete(Kafka.class, "Kafka-with-extra-property.yaml");
    }

    @Test
    void testKafkaWithMissingRequired() {
        Throwable exception = Assertions.assertThrows(KubeClusterException.InvalidResource.class, () -> this.createDelete(Kafka.class, "Kafka-with-missing-required-property.yaml"));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{CoreMatchers.allOf((Matcher[])new Matcher[]{Matchers.containsStringIgnoringCase((String)"spec.zookeeper in body is required"), Matchers.containsStringIgnoringCase((String)"spec.kafka in body is required")}), CoreMatchers.allOf((Matcher[])new Matcher[]{Matchers.containsStringIgnoringCase((String)"spec.kafka: Required value"), Matchers.containsStringIgnoringCase((String)"spec.zookeeper: Required value")})}));
    }

    @Test
    public void testKafkaWithEntityOperator() {
        this.createDelete(Kafka.class, "Kafka-with-entity-operator.yaml");
    }

    @Test
    public void testKafkaWithMaintenance() {
        this.createDelete(Kafka.class, "Kafka-with-maintenance.yaml");
    }

    @Test
    public void testKafkaWithNullMaintenance() {
        Throwable exception = Assertions.assertThrows(KubeClusterException.InvalidResource.class, () -> this.createDelete(Kafka.class, "Kafka-with-null-maintenance.yaml"));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.containsStringIgnoringCase((String)"spec.maintenanceTimeWindows in body must be of type string: \"null\""));
    }

    @Test
    public void testKafkaWithTemplate() {
        this.createDelete(Kafka.class, "Kafka-with-template.yaml");
    }

    @Test
    public void testKafkaWithTlsSidecarWithCustomConfiguration() {
        this.createDelete(Kafka.class, "Kafka-with-tls-sidecar-with-custom-configuration.yaml");
    }

    @Test
    public void testKafkaWithTlsSidecarWithInvalidLogLevel() {
        Throwable exception = Assertions.assertThrows(KubeClusterException.InvalidResource.class, () -> this.createDelete(Kafka.class, "Kafka-with-tls-sidecar-invalid-loglevel.yaml"));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{Matchers.containsStringIgnoringCase((String)"spec.kafka.tlsSidecar.logLevel in body should be one of [emerg alert crit err warning notice info debug]"), Matchers.containsStringIgnoringCase((String)"spec.kafka.tlsSidecar.logLevel: Unsupported value: \"invalid\": supported values: \"emerg\", \"alert\", \"crit\", \"err\", \"warning\", \"notice\", \"info\", \"debug\"")}));
    }

    @Test
    public void testKafkaWithJbodStorage() {
        this.createDelete(Kafka.class, "Kafka-with-jbod-storage.yaml");
    }

    @Test
    public void testKafkaWithJbodStorageOnZookeeper() {
        Throwable exception = Assertions.assertThrows(KubeClusterException.InvalidResource.class, () -> this.createDelete(Kafka.class, "Kafka-with-jbod-storage-on-zookeeper.yaml"));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{Matchers.containsStringIgnoringCase((String)"spec.zookeeper.storage.type in body should be one of [ephemeral persistent-claim]"), Matchers.containsStringIgnoringCase((String)"spec.zookeeper.storage.type: Unsupported value: \"jbod\": supported values: \"ephemeral\", \"persistent-claim\"")}));
    }

    @Test
    public void testKafkaWithInvalidStorage() {
        Throwable exception = Assertions.assertThrows(KubeClusterException.InvalidResource.class, () -> this.createDelete(Kafka.class, "Kafka-with-invalid-storage.yaml"));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{Matchers.containsStringIgnoringCase((String)"spec.kafka.storage.type in body should be one of [ephemeral persistent-claim jbod]"), Matchers.containsStringIgnoringCase((String)"spec.kafka.storage.type: Unsupported value: \"foobar\": supported values: \"ephemeral\", \"persistent-claim\", \"jbod\"")}));
    }

    @Test
    public void testKafkaWithInvalidJmxAuthentication() {
        Throwable exception = Assertions.assertThrows(KubeClusterException.InvalidResource.class, () -> this.createDelete(Kafka.class, "Kafka-with-invalid-jmx-authentication.yaml"));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{Matchers.containsStringIgnoringCase((String)"spec.kafka.jmxOptions.authentication.type in body should be one of [password]"), Matchers.containsStringIgnoringCase((String)"spec.kafka.jmxOptions.authentication.type: Unsupported value: \"not-right\": supported values: \"password\"")}));
    }

    @BeforeAll
    void setupEnvironment() {
        this.cluster.createNamespace(NAMESPACE);
        this.cluster.createCustomResources(new String[]{"../install/cluster-operator/040-Crd-kafka.yaml"});
    }

    @AfterAll
    void teardownEnvironment() {
        this.cluster.deleteCustomResources(new String[]{"../install/cluster-operator/040-Crd-kafka.yaml"});
        this.cluster.deleteNamespaces();
    }
}

