/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.strimzi.api.kafka.model.AbstractCrdIT;
import io.strimzi.api.kafka.model.KafkaConnect;
import io.strimzi.test.k8s.exceptions.KubeClusterException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class KafkaConnectCrdIT
extends AbstractCrdIT {
    public static final String NAMESPACE = "kafkaconnect-crd-it";

    @Test
    void testKafkaConnectV1alpha1() {
        this.assumeKube1_11Plus();
        this.createDelete(KafkaConnect.class, "KafkaConnectV1alpha1.yaml");
    }

    @Test
    void testKafkaConnectV1beta1() {
        this.createDelete(KafkaConnect.class, "KafkaConnectV1beta1.yaml");
    }

    @Test
    void testKafkaConnectMinimal() {
        this.createDelete(KafkaConnect.class, "KafkaConnect-minimal.yaml");
    }

    @Test
    void testKafkaConnectWithExtraProperty() {
        this.createDelete(KafkaConnect.class, "KafkaConnect-with-extra-property.yaml");
    }

    @Test
    void testKafkaConnectWithMissingRequired() {
        Throwable exception = Assertions.assertThrows(KubeClusterException.InvalidResource.class, () -> this.createDelete(KafkaConnect.class, "KafkaConnect-with-missing-required-property.yaml"));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{CoreMatchers.containsStringIgnoringCase((String)"spec.bootstrapServers in body is required"), CoreMatchers.containsStringIgnoringCase((String)"spec.bootstrapServers: Required value")}));
    }

    @Test
    void testKafkaConnectWithInvalidReplicas() {
        Throwable exception = Assertions.assertThrows(KubeClusterException.InvalidResource.class, () -> this.createDelete(KafkaConnect.class, "KafkaConnect-with-invalid-replicas.yaml"));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.containsStringIgnoringCase((String)"spec.replicas in body must be of type integer: \"string\""));
    }

    @Test
    void testKafkaConnectWithTls() {
        this.createDelete(KafkaConnect.class, "KafkaConnect-with-tls.yaml");
    }

    @Test
    void testKafkaConnectWithTlsAuth() {
        this.createDelete(KafkaConnect.class, "KafkaConnect-with-tls-auth.yaml");
    }

    @Test
    void testKafkaConnectWithTlsAuthWithMissingRequired() {
        Throwable exception = Assertions.assertThrows(KubeClusterException.InvalidResource.class, () -> this.createDelete(KafkaConnect.class, "KafkaConnect-with-tls-auth-with-missing-required.yaml"));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsStringIgnoringCase((String)"spec.authentication.certificateAndKey.certificate in body is required"), CoreMatchers.containsStringIgnoringCase((String)"spec.authentication.certificateAndKey.key in body is required")}), CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsStringIgnoringCase((String)"spec.authentication.certificateAndKey.certificate: Required value"), CoreMatchers.containsStringIgnoringCase((String)"spec.authentication.certificateAndKey.key: Required value")})}));
    }

    @Test
    void testKafkaConnectWithScramSha512Auth() {
        this.createDelete(KafkaConnect.class, "KafkaConnect-with-scram-sha-512-auth.yaml");
    }

    @Test
    public void testKafkaConnectWithTemplate() {
        this.createDelete(KafkaConnect.class, "KafkaConnect-with-template.yaml");
    }

    @Test
    public void testKafkaConnectWithExternalConfiguration() {
        this.createDelete(KafkaConnect.class, "KafkaConnect-with-external-configuration.yaml");
    }

    @Test
    public void testKafkaConnectWithInvalidExternalConfiguration() {
        Throwable exception = Assertions.assertThrows(KubeClusterException.InvalidResource.class, () -> this.createDelete(KafkaConnect.class, "KafkaConnect-with-invalid-external-configuration.yaml"));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{CoreMatchers.containsStringIgnoringCase((String)"spec.externalConfiguration.env.valueFrom in body is required"), CoreMatchers.containsStringIgnoringCase((String)"spec.externalConfiguration.env.valueFrom: Required value")}));
    }

    @BeforeAll
    void setupEnvironment() {
        this.cluster.createNamespace(NAMESPACE);
        this.cluster.createCustomResources(new String[]{"../install/cluster-operator/041-Crd-kafkaconnect.yaml"});
    }

    @AfterAll
    void teardownEnvironment() {
        this.cluster.deleteCustomResources();
        this.cluster.deleteNamespaces();
    }
}

