/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.strimzi.api.kafka.model.AbstractCrdIT;
import io.strimzi.api.kafka.model.KafkaBridge;
import io.strimzi.api.kafka.model.KafkaMirrorMaker;
import io.strimzi.test.k8s.exceptions.KubeClusterException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class KafkaBridgeCrdIT
extends AbstractCrdIT {
    public static final String NAMESPACE = "kafkabridge-crd-it";

    @Test
    void testKafkaBridgeV1alpha1() {
        this.assumeKube1_11Plus();
        this.createDelete(KafkaBridge.class, "KafkaBridgeV1alpha1.yaml");
    }

    @Test
    void testKafkaBridgeMinimal() {
        this.createDelete(KafkaBridge.class, "KafkaBridge-minimal.yaml");
    }

    @Test
    void testKafkaBridgeWithExtraProperty() {
        this.createDelete(KafkaMirrorMaker.class, "KafkaBridge-with-extra-property.yaml");
    }

    @Test
    void testKafkaBridgeWithMissingRequired() {
        Throwable exception = Assertions.assertThrows(KubeClusterException.InvalidResource.class, () -> this.createDelete(KafkaBridge.class, "KafkaBridge-with-missing-required-property.yaml"));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{CoreMatchers.containsStringIgnoringCase((String)"spec.bootstrapServers in body is required"), CoreMatchers.containsStringIgnoringCase((String)"spec.bootstrapServers: Required value")}));
    }

    @Test
    void testKafkaBridgeWithTls() {
        this.createDelete(KafkaBridge.class, "KafkaBridge-with-tls.yaml");
    }

    @Test
    void testKafkaBridgeWithTlsAuth() {
        this.createDelete(KafkaBridge.class, "KafkaBridge-with-tls-auth.yaml");
    }

    @Test
    void testKafkaBridgeWithTlsAuthWithMissingRequired() {
        Throwable exception = Assertions.assertThrows(KubeClusterException.InvalidResource.class, () -> this.createDelete(KafkaBridge.class, "KafkaBridge-with-tls-auth-with-missing-required.yaml"));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsStringIgnoringCase((String)"spec.authentication.certificateAndKey.certificate in body is required"), CoreMatchers.containsStringIgnoringCase((String)"spec.authentication.certificateAndKey.key in body is required")}), CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsStringIgnoringCase((String)"spec.authentication.certificateAndKey.certificate: Required value"), CoreMatchers.containsStringIgnoringCase((String)"spec.authentication.certificateAndKey.key: Required value")})}));
    }

    @Test
    void testKafkaBridgeWithScramSha512Auth() {
        this.createDelete(KafkaBridge.class, "KafkaBridge-with-scram-sha-512-auth.yaml");
    }

    @Test
    void testKafkaBridgeWithTemplate() {
        this.createDelete(KafkaBridge.class, "KafkaBridge-with-template.yaml");
    }

    @Test
    void testKafkaBridgeWithJaegerTracing() {
        this.createDelete(KafkaBridge.class, "KafkaBridge-with-jaeger-tracing.yaml");
    }

    @Test
    void testKafkaBridgeWithWrongTracingType() {
        Throwable exception = Assertions.assertThrows(KubeClusterException.InvalidResource.class, () -> this.createDelete(KafkaBridge.class, "KafkaBridge-with-wrong-tracing-type.yaml"));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{CoreMatchers.containsStringIgnoringCase((String)"spec.tracing.type in body should be one of [jaeger]"), CoreMatchers.containsStringIgnoringCase((String)"spec.tracing.type: Unsupported value: \"wrongtype\": supported values: \"jaeger\"")}));
    }

    @Test
    void testKafkaBridgeWithMissingTracingType() {
        Throwable exception = Assertions.assertThrows(KubeClusterException.InvalidResource.class, () -> this.createDelete(KafkaBridge.class, "KafkaBridge-with-missing-tracing-type.yaml"));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{CoreMatchers.containsStringIgnoringCase((String)"spec.tracing.type in body is required"), CoreMatchers.containsStringIgnoringCase((String)"spec.tracing.type: Required value")}));
    }

    @BeforeAll
    void setupEnvironment() {
        this.cluster.createNamespace(NAMESPACE);
        this.cluster.createCustomResources(new String[]{"../install/cluster-operator/046-Crd-kafkabridge.yaml"});
    }

    @AfterAll
    void teardownEnvironment() {
        this.cluster.deleteCustomResources();
        this.cluster.deleteNamespaces();
    }
}

