/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinitionSpec;
import io.fabric8.kubernetes.api.model.rbac.ClusterRoleBinding;
import io.fabric8.kubernetes.api.model.rbac.RoleBinding;
import io.strimzi.api.kafka.Crds;
import io.strimzi.test.TestUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ExamplesTest {
    private static final Pattern PARAMETER_PATTERN;

    @Test
    public void examples() throws Exception {
        this.validateRecursively(new File("../examples"));
    }

    private void validateRecursively(File directory) throws IOException {
        for (File f : directory.listFiles()) {
            if (f.isDirectory()) {
                this.validateRecursively(f);
                continue;
            }
            if (!f.isFile() || !f.getName().endsWith(".yaml") && !f.getName().endsWith(".yml")) continue;
            this.validate(f);
        }
    }

    private void validate(File f) {
        try {
            YAMLMapper mapper = new YAMLMapper();
            String content = TestUtils.readFile((File)f);
            JsonNode rootNode = mapper.readTree(content);
            String resourceKind = this.getKind(rootNode);
            if ("Template".equals(resourceKind)) {
                this.validateTemplate(rootNode);
            } else {
                this.validate(content);
            }
        }
        catch (AssertionError | Exception e) {
            throw new AssertionError("Invalid example yaml in " + f.getPath() + ": " + ((Throwable)e).getMessage(), (Throwable)e);
        }
    }

    private void validate(String content) {
        KubernetesResource resource = (KubernetesResource)TestUtils.fromYamlString((String)content, KubernetesResource.class, (boolean)false);
        this.recurseForAdditionalProperties(new Stack<String>(), resource);
    }

    private void recurseForAdditionalProperties(Stack<String> path, Object resource) {
        try {
            Class<?> cls = resource.getClass();
            if (RoleBinding.class.equals(cls) || ClusterRoleBinding.class.equals(cls)) {
                return;
            }
            for (Method method : cls.getMethods()) {
                this.checkForJsonAnyGetter(path, resource, cls, method);
            }
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private void checkForJsonAnyGetter(Stack<String> path, Object resource, Class<?> cls, Method method) throws IllegalAccessException, InvocationTargetException {
        if (method.isAnnotationPresent(JsonAnyGetter.class)) {
            HashMap additionalProperties = (HashMap)method.invoke(resource, new Object[0]);
            if (CustomResourceDefinitionSpec.class.equals(cls)) {
                additionalProperties = new HashMap(additionalProperties);
                additionalProperties.remove("validation");
            }
            if (additionalProperties != null && !additionalProperties.isEmpty()) {
                Assertions.fail((String)("object at path " + path.stream().collect(Collectors.joining("/")) + " has additional properties " + additionalProperties.keySet()));
            }
        } else if (this.isGetter(method)) {
            method.setAccessible(true);
            Object result = method.invoke(resource, new Object[0]);
            if (result != null && !result.getClass().isPrimitive() && !result.getClass().isEnum()) {
                path.push(method.getName());
                this.recurseForAdditionalProperties(path, result);
                path.pop();
            }
        }
    }

    private boolean isGetter(Method method) {
        String name = method.getName();
        boolean hasGetterName = !name.equals("getClass") && (name.startsWith("get") && name.length() > 3 || name.startsWith("is") && name.length() > 2);
        return method.getParameterCount() == 0 && hasGetterName && !Modifier.isStatic(method.getModifiers()) && !method.getReturnType().equals(Void.TYPE);
    }

    private void validateTemplate(JsonNode rootNode) throws JsonProcessingException {
        JsonNode parameters = rootNode.get("parameters");
        HashMap<String, String> params = new HashMap<String, String>();
        for (JsonNode parameter : parameters) {
            String value;
            String name = parameter.get("name").asText();
            JsonNode valueNode = parameter.get("value");
            switch (valueNode.getNodeType()) {
                case NULL: {
                    value = null;
                    break;
                }
                case NUMBER: 
                case BOOLEAN: {
                    value = valueNode.toString();
                    break;
                }
                case STRING: {
                    value = valueNode.asText();
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported JSON type " + valueNode.getNodeType());
                }
            }
            params.put(name, value);
        }
        for (JsonNode object : rootNode.get("objects")) {
            String s = new YAMLMapper().enable(YAMLGenerator.Feature.MINIMIZE_QUOTES).enable(SerializationFeature.INDENT_OUTPUT).writeValueAsString((Object)object);
            Matcher matcher = PARAMETER_PATTERN.matcher(s);
            StringBuilder sb = new StringBuilder();
            int last = 0;
            while (matcher.find()) {
                sb.append(s, last, matcher.start());
                String paramName = matcher.group(1);
                sb.append(params.get(paramName));
                last = matcher.end();
            }
            sb.append(s.substring(last));
            String yamlContent = sb.toString();
            this.validate(yamlContent);
        }
    }

    private String getKind(JsonNode rootNode) {
        return rootNode.get("kind").asText();
    }

    static {
        Crds.registerCustomKinds();
        PARAMETER_PATTERN = Pattern.compile("\\$\\{\\{(.+?)\\}?\\}");
    }
}

