/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.client.CustomResource;
import io.strimzi.test.TestUtils;
import java.io.IOException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractCrdTest<R extends CustomResource> {
    private final Class<R> crdClass;
    private final String kind;

    protected AbstractCrdTest(Class<R> crdClass) {
        this.crdClass = crdClass;
        try {
            this.kind = ((CustomResource)crdClass.newInstance()).getKind();
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    protected void assertDesiredResource(R k, String resource) throws IOException {
        String content = TestUtils.readResource(this.getClass(), (String)resource);
        if (content != null) {
            String ssStr = TestUtils.toYamlString(k);
            MatcherAssert.assertThat((Object)content.trim(), (Matcher)CoreMatchers.is((Object)ssStr.trim()));
        } else {
            Assertions.fail((String)("The resource " + resource + " does not exist"));
        }
    }

    @Test
    public void roundTrip() throws IOException, ReflectiveOperationException {
        String resourceName = this.crdClass.getSimpleName() + ".yaml";
        CustomResource model = (CustomResource)TestUtils.fromYaml((String)resourceName, this.crdClass);
        MatcherAssert.assertThat((String)"The classpath resource \" + resourceName + \" does not exist", (Object)model, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        ObjectMeta metadata = model.getMetadata();
        MatcherAssert.assertThat((Object)metadata, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.assertDesiredResource(model, this.crdClass.getSimpleName() + ".out.yaml");
        this.assertDesiredResource((CustomResource)TestUtils.fromYamlString((String)TestUtils.toYamlString((Object)model), this.crdClass), this.crdClass.getSimpleName() + ".out.yaml");
    }
}

