/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.VersionInfo;
import io.strimzi.test.TestUtils;
import io.strimzi.test.k8s.KubeClusterResource;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public abstract class AbstractCrdIT {
    protected KubeClusterResource cluster = KubeClusterResource.getInstance();

    protected void assumeKube1_11Plus() {
        VersionInfo version = new DefaultKubernetesClient().getVersion();
        Assumptions.assumeTrue(("1".equals(version.getMajor()) && Integer.parseInt(version.getMinor().split("\\D")[0]) >= 11 ? 1 : 0) != 0);
    }

    protected <T extends CustomResource> void createDelete(Class<T> resourceClass, String resource) {
        String ssStr = TestUtils.readResource(resourceClass, (String)resource);
        MatcherAssert.assertThat((String)("Class path resource " + resource + " was missing"), (Object)ssStr, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.createDelete(ssStr);
        CustomResource model = (CustomResource)TestUtils.fromYaml((String)resource, resourceClass, (boolean)false);
        ssStr = TestUtils.toYamlString((Object)model);
        try {
            this.createDelete(ssStr);
        }
        catch (Error | RuntimeException e) {
            System.err.println(ssStr);
            throw new AssertionError("Create delete failed after first round-trip -- maybe a problem with a defaulted value?", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDelete(String ssStr) {
        RuntimeException thrown = null;
        RuntimeException thrown2 = null;
        try {
            try {
                KubeClusterResource.cmdKubeClient().applyContent(ssStr);
            }
            catch (RuntimeException t) {
                thrown = t;
            }
        }
        finally {
            try {
                KubeClusterResource.cmdKubeClient().deleteContent(ssStr);
            }
            catch (RuntimeException t) {
                thrown2 = t;
            }
        }
        if (thrown != null) {
            if (thrown2 != null) {
                thrown.addSuppressed(thrown2);
            }
            throw thrown;
        }
        if (thrown2 != null) {
            throw thrown2;
        }
    }

    @BeforeEach
    public void setupTests() {
        this.cluster.before();
    }
}

