package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;

public class KafkaConnectTemplateFluentImpl<A extends KafkaConnectTemplateFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements KafkaConnectTemplateFluent<A>{

    private ResourceTemplateBuilder deployment;
    private PodTemplateBuilder pod;
    private ResourceTemplateBuilder apiService;
    private PodDisruptionBudgetTemplateBuilder podDisruptionBudget;
    private ContainerTemplateBuilder connectContainer;

    public KafkaConnectTemplateFluentImpl(){
    }
    public KafkaConnectTemplateFluentImpl(KafkaConnectTemplate instance){
            this.withDeployment(instance.getDeployment());

            this.withPod(instance.getPod());

            this.withApiService(instance.getApiService());

            this.withPodDisruptionBudget(instance.getPodDisruptionBudget());

            this.withConnectContainer(instance.getConnectContainer());

    }

    
/**
 * This method has been deprecated, please use method buildDeployment instead.
 * @return The buildable object.
 */
@Deprecated public ResourceTemplate getDeployment(){
            return this.deployment!=null?this.deployment.build():null;
    }

    public ResourceTemplate buildDeployment(){
            return this.deployment!=null?this.deployment.build():null;
    }

    public A withDeployment(ResourceTemplate deployment){
            _visitables.get("deployment").remove(this.deployment);
            if (deployment!=null){ this.deployment= new ResourceTemplateBuilder(deployment); _visitables.get("deployment").add(this.deployment);} return (A) this;
    }

    public Boolean hasDeployment(){
            return this.deployment != null;
    }

    public KafkaConnectTemplateFluent.DeploymentNested<A> withNewDeployment(){
            return new DeploymentNestedImpl();
    }

    public KafkaConnectTemplateFluent.DeploymentNested<A> withNewDeploymentLike(ResourceTemplate item){
            return new DeploymentNestedImpl(item);
    }

    public KafkaConnectTemplateFluent.DeploymentNested<A> editDeployment(){
            return withNewDeploymentLike(getDeployment());
    }

    public KafkaConnectTemplateFluent.DeploymentNested<A> editOrNewDeployment(){
            return withNewDeploymentLike(getDeployment() != null ? getDeployment(): new ResourceTemplateBuilder().build());
    }

    public KafkaConnectTemplateFluent.DeploymentNested<A> editOrNewDeploymentLike(ResourceTemplate item){
            return withNewDeploymentLike(getDeployment() != null ? getDeployment(): item);
    }

    
/**
 * This method has been deprecated, please use method buildPod instead.
 * @return The buildable object.
 */
@Deprecated public PodTemplate getPod(){
            return this.pod!=null?this.pod.build():null;
    }

    public PodTemplate buildPod(){
            return this.pod!=null?this.pod.build():null;
    }

    public A withPod(PodTemplate pod){
            _visitables.get("pod").remove(this.pod);
            if (pod!=null){ this.pod= new PodTemplateBuilder(pod); _visitables.get("pod").add(this.pod);} return (A) this;
    }

    public Boolean hasPod(){
            return this.pod != null;
    }

    public KafkaConnectTemplateFluent.PodNested<A> withNewPod(){
            return new PodNestedImpl();
    }

    public KafkaConnectTemplateFluent.PodNested<A> withNewPodLike(PodTemplate item){
            return new PodNestedImpl(item);
    }

    public KafkaConnectTemplateFluent.PodNested<A> editPod(){
            return withNewPodLike(getPod());
    }

    public KafkaConnectTemplateFluent.PodNested<A> editOrNewPod(){
            return withNewPodLike(getPod() != null ? getPod(): new PodTemplateBuilder().build());
    }

    public KafkaConnectTemplateFluent.PodNested<A> editOrNewPodLike(PodTemplate item){
            return withNewPodLike(getPod() != null ? getPod(): item);
    }

    
/**
 * This method has been deprecated, please use method buildApiService instead.
 * @return The buildable object.
 */
@Deprecated public ResourceTemplate getApiService(){
            return this.apiService!=null?this.apiService.build():null;
    }

    public ResourceTemplate buildApiService(){
            return this.apiService!=null?this.apiService.build():null;
    }

    public A withApiService(ResourceTemplate apiService){
            _visitables.get("apiService").remove(this.apiService);
            if (apiService!=null){ this.apiService= new ResourceTemplateBuilder(apiService); _visitables.get("apiService").add(this.apiService);} return (A) this;
    }

    public Boolean hasApiService(){
            return this.apiService != null;
    }

    public KafkaConnectTemplateFluent.ApiServiceNested<A> withNewApiService(){
            return new ApiServiceNestedImpl();
    }

    public KafkaConnectTemplateFluent.ApiServiceNested<A> withNewApiServiceLike(ResourceTemplate item){
            return new ApiServiceNestedImpl(item);
    }

    public KafkaConnectTemplateFluent.ApiServiceNested<A> editApiService(){
            return withNewApiServiceLike(getApiService());
    }

    public KafkaConnectTemplateFluent.ApiServiceNested<A> editOrNewApiService(){
            return withNewApiServiceLike(getApiService() != null ? getApiService(): new ResourceTemplateBuilder().build());
    }

    public KafkaConnectTemplateFluent.ApiServiceNested<A> editOrNewApiServiceLike(ResourceTemplate item){
            return withNewApiServiceLike(getApiService() != null ? getApiService(): item);
    }

    
/**
 * This method has been deprecated, please use method buildPodDisruptionBudget instead.
 * @return The buildable object.
 */
@Deprecated public PodDisruptionBudgetTemplate getPodDisruptionBudget(){
            return this.podDisruptionBudget!=null?this.podDisruptionBudget.build():null;
    }

    public PodDisruptionBudgetTemplate buildPodDisruptionBudget(){
            return this.podDisruptionBudget!=null?this.podDisruptionBudget.build():null;
    }

    public A withPodDisruptionBudget(PodDisruptionBudgetTemplate podDisruptionBudget){
            _visitables.get("podDisruptionBudget").remove(this.podDisruptionBudget);
            if (podDisruptionBudget!=null){ this.podDisruptionBudget= new PodDisruptionBudgetTemplateBuilder(podDisruptionBudget); _visitables.get("podDisruptionBudget").add(this.podDisruptionBudget);} return (A) this;
    }

    public Boolean hasPodDisruptionBudget(){
            return this.podDisruptionBudget != null;
    }

    public KafkaConnectTemplateFluent.PodDisruptionBudgetNested<A> withNewPodDisruptionBudget(){
            return new PodDisruptionBudgetNestedImpl();
    }

    public KafkaConnectTemplateFluent.PodDisruptionBudgetNested<A> withNewPodDisruptionBudgetLike(PodDisruptionBudgetTemplate item){
            return new PodDisruptionBudgetNestedImpl(item);
    }

    public KafkaConnectTemplateFluent.PodDisruptionBudgetNested<A> editPodDisruptionBudget(){
            return withNewPodDisruptionBudgetLike(getPodDisruptionBudget());
    }

    public KafkaConnectTemplateFluent.PodDisruptionBudgetNested<A> editOrNewPodDisruptionBudget(){
            return withNewPodDisruptionBudgetLike(getPodDisruptionBudget() != null ? getPodDisruptionBudget(): new PodDisruptionBudgetTemplateBuilder().build());
    }

    public KafkaConnectTemplateFluent.PodDisruptionBudgetNested<A> editOrNewPodDisruptionBudgetLike(PodDisruptionBudgetTemplate item){
            return withNewPodDisruptionBudgetLike(getPodDisruptionBudget() != null ? getPodDisruptionBudget(): item);
    }

    
/**
 * This method has been deprecated, please use method buildConnectContainer instead.
 * @return The buildable object.
 */
@Deprecated public ContainerTemplate getConnectContainer(){
            return this.connectContainer!=null?this.connectContainer.build():null;
    }

    public ContainerTemplate buildConnectContainer(){
            return this.connectContainer!=null?this.connectContainer.build():null;
    }

    public A withConnectContainer(ContainerTemplate connectContainer){
            _visitables.get("connectContainer").remove(this.connectContainer);
            if (connectContainer!=null){ this.connectContainer= new ContainerTemplateBuilder(connectContainer); _visitables.get("connectContainer").add(this.connectContainer);} return (A) this;
    }

    public Boolean hasConnectContainer(){
            return this.connectContainer != null;
    }

    public KafkaConnectTemplateFluent.ConnectContainerNested<A> withNewConnectContainer(){
            return new ConnectContainerNestedImpl();
    }

    public KafkaConnectTemplateFluent.ConnectContainerNested<A> withNewConnectContainerLike(ContainerTemplate item){
            return new ConnectContainerNestedImpl(item);
    }

    public KafkaConnectTemplateFluent.ConnectContainerNested<A> editConnectContainer(){
            return withNewConnectContainerLike(getConnectContainer());
    }

    public KafkaConnectTemplateFluent.ConnectContainerNested<A> editOrNewConnectContainer(){
            return withNewConnectContainerLike(getConnectContainer() != null ? getConnectContainer(): new ContainerTemplateBuilder().build());
    }

    public KafkaConnectTemplateFluent.ConnectContainerNested<A> editOrNewConnectContainerLike(ContainerTemplate item){
            return withNewConnectContainerLike(getConnectContainer() != null ? getConnectContainer(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            KafkaConnectTemplateFluentImpl that = (KafkaConnectTemplateFluentImpl) o;
            if (deployment != null ? !deployment.equals(that.deployment) :that.deployment != null) return false;
            if (pod != null ? !pod.equals(that.pod) :that.pod != null) return false;
            if (apiService != null ? !apiService.equals(that.apiService) :that.apiService != null) return false;
            if (podDisruptionBudget != null ? !podDisruptionBudget.equals(that.podDisruptionBudget) :that.podDisruptionBudget != null) return false;
            if (connectContainer != null ? !connectContainer.equals(that.connectContainer) :that.connectContainer != null) return false;
            return true;
    }


    public class DeploymentNestedImpl<N> extends ResourceTemplateFluentImpl<KafkaConnectTemplateFluent.DeploymentNested<N>> implements KafkaConnectTemplateFluent.DeploymentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ResourceTemplateBuilder builder;
    
            DeploymentNestedImpl(ResourceTemplate item){
                    this.builder = new ResourceTemplateBuilder(this, item);
            }
            DeploymentNestedImpl(){
                    this.builder = new ResourceTemplateBuilder(this);
            }
    
    public N and(){
            return (N) KafkaConnectTemplateFluentImpl.this.withDeployment(builder.build());
    }
    public N endDeployment(){
            return and();
    }

}
    public class PodNestedImpl<N> extends PodTemplateFluentImpl<KafkaConnectTemplateFluent.PodNested<N>> implements KafkaConnectTemplateFluent.PodNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PodTemplateBuilder builder;
    
            PodNestedImpl(PodTemplate item){
                    this.builder = new PodTemplateBuilder(this, item);
            }
            PodNestedImpl(){
                    this.builder = new PodTemplateBuilder(this);
            }
    
    public N and(){
            return (N) KafkaConnectTemplateFluentImpl.this.withPod(builder.build());
    }
    public N endPod(){
            return and();
    }

}
    public class ApiServiceNestedImpl<N> extends ResourceTemplateFluentImpl<KafkaConnectTemplateFluent.ApiServiceNested<N>> implements KafkaConnectTemplateFluent.ApiServiceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ResourceTemplateBuilder builder;
    
            ApiServiceNestedImpl(ResourceTemplate item){
                    this.builder = new ResourceTemplateBuilder(this, item);
            }
            ApiServiceNestedImpl(){
                    this.builder = new ResourceTemplateBuilder(this);
            }
    
    public N and(){
            return (N) KafkaConnectTemplateFluentImpl.this.withApiService(builder.build());
    }
    public N endApiService(){
            return and();
    }

}
    public class PodDisruptionBudgetNestedImpl<N> extends PodDisruptionBudgetTemplateFluentImpl<KafkaConnectTemplateFluent.PodDisruptionBudgetNested<N>> implements KafkaConnectTemplateFluent.PodDisruptionBudgetNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PodDisruptionBudgetTemplateBuilder builder;
    
            PodDisruptionBudgetNestedImpl(PodDisruptionBudgetTemplate item){
                    this.builder = new PodDisruptionBudgetTemplateBuilder(this, item);
            }
            PodDisruptionBudgetNestedImpl(){
                    this.builder = new PodDisruptionBudgetTemplateBuilder(this);
            }
    
    public N and(){
            return (N) KafkaConnectTemplateFluentImpl.this.withPodDisruptionBudget(builder.build());
    }
    public N endPodDisruptionBudget(){
            return and();
    }

}
    public class ConnectContainerNestedImpl<N> extends ContainerTemplateFluentImpl<KafkaConnectTemplateFluent.ConnectContainerNested<N>> implements KafkaConnectTemplateFluent.ConnectContainerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ContainerTemplateBuilder builder;
    
            ConnectContainerNestedImpl(ContainerTemplate item){
                    this.builder = new ContainerTemplateBuilder(this, item);
            }
            ConnectContainerNestedImpl(){
                    this.builder = new ContainerTemplateBuilder(this);
            }
    
    public N and(){
            return (N) KafkaConnectTemplateFluentImpl.this.withConnectContainer(builder.build());
    }
    public N endConnectContainer(){
            return and();
    }

}


}
