package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;

public class KafkaBridgeTemplateFluentImpl<A extends KafkaBridgeTemplateFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements KafkaBridgeTemplateFluent<A>{

    private ResourceTemplateBuilder deployment;
    private PodTemplateBuilder pod;
    private ResourceTemplateBuilder apiService;
    private PodDisruptionBudgetTemplateBuilder podDisruptionBudget;
    private ContainerTemplateBuilder bridgeContainer;

    public KafkaBridgeTemplateFluentImpl(){
    }
    public KafkaBridgeTemplateFluentImpl(KafkaBridgeTemplate instance){
            this.withDeployment(instance.getDeployment());

            this.withPod(instance.getPod());

            this.withApiService(instance.getApiService());

            this.withPodDisruptionBudget(instance.getPodDisruptionBudget());

            this.withBridgeContainer(instance.getBridgeContainer());

    }

    
/**
 * This method has been deprecated, please use method buildDeployment instead.
 * @return The buildable object.
 */
@Deprecated public ResourceTemplate getDeployment(){
            return this.deployment!=null?this.deployment.build():null;
    }

    public ResourceTemplate buildDeployment(){
            return this.deployment!=null?this.deployment.build():null;
    }

    public A withDeployment(ResourceTemplate deployment){
            _visitables.get("deployment").remove(this.deployment);
            if (deployment!=null){ this.deployment= new ResourceTemplateBuilder(deployment); _visitables.get("deployment").add(this.deployment);} return (A) this;
    }

    public Boolean hasDeployment(){
            return this.deployment != null;
    }

    public KafkaBridgeTemplateFluent.DeploymentNested<A> withNewDeployment(){
            return new DeploymentNestedImpl();
    }

    public KafkaBridgeTemplateFluent.DeploymentNested<A> withNewDeploymentLike(ResourceTemplate item){
            return new DeploymentNestedImpl(item);
    }

    public KafkaBridgeTemplateFluent.DeploymentNested<A> editDeployment(){
            return withNewDeploymentLike(getDeployment());
    }

    public KafkaBridgeTemplateFluent.DeploymentNested<A> editOrNewDeployment(){
            return withNewDeploymentLike(getDeployment() != null ? getDeployment(): new ResourceTemplateBuilder().build());
    }

    public KafkaBridgeTemplateFluent.DeploymentNested<A> editOrNewDeploymentLike(ResourceTemplate item){
            return withNewDeploymentLike(getDeployment() != null ? getDeployment(): item);
    }

    
/**
 * This method has been deprecated, please use method buildPod instead.
 * @return The buildable object.
 */
@Deprecated public PodTemplate getPod(){
            return this.pod!=null?this.pod.build():null;
    }

    public PodTemplate buildPod(){
            return this.pod!=null?this.pod.build():null;
    }

    public A withPod(PodTemplate pod){
            _visitables.get("pod").remove(this.pod);
            if (pod!=null){ this.pod= new PodTemplateBuilder(pod); _visitables.get("pod").add(this.pod);} return (A) this;
    }

    public Boolean hasPod(){
            return this.pod != null;
    }

    public KafkaBridgeTemplateFluent.PodNested<A> withNewPod(){
            return new PodNestedImpl();
    }

    public KafkaBridgeTemplateFluent.PodNested<A> withNewPodLike(PodTemplate item){
            return new PodNestedImpl(item);
    }

    public KafkaBridgeTemplateFluent.PodNested<A> editPod(){
            return withNewPodLike(getPod());
    }

    public KafkaBridgeTemplateFluent.PodNested<A> editOrNewPod(){
            return withNewPodLike(getPod() != null ? getPod(): new PodTemplateBuilder().build());
    }

    public KafkaBridgeTemplateFluent.PodNested<A> editOrNewPodLike(PodTemplate item){
            return withNewPodLike(getPod() != null ? getPod(): item);
    }

    
/**
 * This method has been deprecated, please use method buildApiService instead.
 * @return The buildable object.
 */
@Deprecated public ResourceTemplate getApiService(){
            return this.apiService!=null?this.apiService.build():null;
    }

    public ResourceTemplate buildApiService(){
            return this.apiService!=null?this.apiService.build():null;
    }

    public A withApiService(ResourceTemplate apiService){
            _visitables.get("apiService").remove(this.apiService);
            if (apiService!=null){ this.apiService= new ResourceTemplateBuilder(apiService); _visitables.get("apiService").add(this.apiService);} return (A) this;
    }

    public Boolean hasApiService(){
            return this.apiService != null;
    }

    public KafkaBridgeTemplateFluent.ApiServiceNested<A> withNewApiService(){
            return new ApiServiceNestedImpl();
    }

    public KafkaBridgeTemplateFluent.ApiServiceNested<A> withNewApiServiceLike(ResourceTemplate item){
            return new ApiServiceNestedImpl(item);
    }

    public KafkaBridgeTemplateFluent.ApiServiceNested<A> editApiService(){
            return withNewApiServiceLike(getApiService());
    }

    public KafkaBridgeTemplateFluent.ApiServiceNested<A> editOrNewApiService(){
            return withNewApiServiceLike(getApiService() != null ? getApiService(): new ResourceTemplateBuilder().build());
    }

    public KafkaBridgeTemplateFluent.ApiServiceNested<A> editOrNewApiServiceLike(ResourceTemplate item){
            return withNewApiServiceLike(getApiService() != null ? getApiService(): item);
    }

    
/**
 * This method has been deprecated, please use method buildPodDisruptionBudget instead.
 * @return The buildable object.
 */
@Deprecated public PodDisruptionBudgetTemplate getPodDisruptionBudget(){
            return this.podDisruptionBudget!=null?this.podDisruptionBudget.build():null;
    }

    public PodDisruptionBudgetTemplate buildPodDisruptionBudget(){
            return this.podDisruptionBudget!=null?this.podDisruptionBudget.build():null;
    }

    public A withPodDisruptionBudget(PodDisruptionBudgetTemplate podDisruptionBudget){
            _visitables.get("podDisruptionBudget").remove(this.podDisruptionBudget);
            if (podDisruptionBudget!=null){ this.podDisruptionBudget= new PodDisruptionBudgetTemplateBuilder(podDisruptionBudget); _visitables.get("podDisruptionBudget").add(this.podDisruptionBudget);} return (A) this;
    }

    public Boolean hasPodDisruptionBudget(){
            return this.podDisruptionBudget != null;
    }

    public KafkaBridgeTemplateFluent.PodDisruptionBudgetNested<A> withNewPodDisruptionBudget(){
            return new PodDisruptionBudgetNestedImpl();
    }

    public KafkaBridgeTemplateFluent.PodDisruptionBudgetNested<A> withNewPodDisruptionBudgetLike(PodDisruptionBudgetTemplate item){
            return new PodDisruptionBudgetNestedImpl(item);
    }

    public KafkaBridgeTemplateFluent.PodDisruptionBudgetNested<A> editPodDisruptionBudget(){
            return withNewPodDisruptionBudgetLike(getPodDisruptionBudget());
    }

    public KafkaBridgeTemplateFluent.PodDisruptionBudgetNested<A> editOrNewPodDisruptionBudget(){
            return withNewPodDisruptionBudgetLike(getPodDisruptionBudget() != null ? getPodDisruptionBudget(): new PodDisruptionBudgetTemplateBuilder().build());
    }

    public KafkaBridgeTemplateFluent.PodDisruptionBudgetNested<A> editOrNewPodDisruptionBudgetLike(PodDisruptionBudgetTemplate item){
            return withNewPodDisruptionBudgetLike(getPodDisruptionBudget() != null ? getPodDisruptionBudget(): item);
    }

    
/**
 * This method has been deprecated, please use method buildBridgeContainer instead.
 * @return The buildable object.
 */
@Deprecated public ContainerTemplate getBridgeContainer(){
            return this.bridgeContainer!=null?this.bridgeContainer.build():null;
    }

    public ContainerTemplate buildBridgeContainer(){
            return this.bridgeContainer!=null?this.bridgeContainer.build():null;
    }

    public A withBridgeContainer(ContainerTemplate bridgeContainer){
            _visitables.get("bridgeContainer").remove(this.bridgeContainer);
            if (bridgeContainer!=null){ this.bridgeContainer= new ContainerTemplateBuilder(bridgeContainer); _visitables.get("bridgeContainer").add(this.bridgeContainer);} return (A) this;
    }

    public Boolean hasBridgeContainer(){
            return this.bridgeContainer != null;
    }

    public KafkaBridgeTemplateFluent.BridgeContainerNested<A> withNewBridgeContainer(){
            return new BridgeContainerNestedImpl();
    }

    public KafkaBridgeTemplateFluent.BridgeContainerNested<A> withNewBridgeContainerLike(ContainerTemplate item){
            return new BridgeContainerNestedImpl(item);
    }

    public KafkaBridgeTemplateFluent.BridgeContainerNested<A> editBridgeContainer(){
            return withNewBridgeContainerLike(getBridgeContainer());
    }

    public KafkaBridgeTemplateFluent.BridgeContainerNested<A> editOrNewBridgeContainer(){
            return withNewBridgeContainerLike(getBridgeContainer() != null ? getBridgeContainer(): new ContainerTemplateBuilder().build());
    }

    public KafkaBridgeTemplateFluent.BridgeContainerNested<A> editOrNewBridgeContainerLike(ContainerTemplate item){
            return withNewBridgeContainerLike(getBridgeContainer() != null ? getBridgeContainer(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            KafkaBridgeTemplateFluentImpl that = (KafkaBridgeTemplateFluentImpl) o;
            if (deployment != null ? !deployment.equals(that.deployment) :that.deployment != null) return false;
            if (pod != null ? !pod.equals(that.pod) :that.pod != null) return false;
            if (apiService != null ? !apiService.equals(that.apiService) :that.apiService != null) return false;
            if (podDisruptionBudget != null ? !podDisruptionBudget.equals(that.podDisruptionBudget) :that.podDisruptionBudget != null) return false;
            if (bridgeContainer != null ? !bridgeContainer.equals(that.bridgeContainer) :that.bridgeContainer != null) return false;
            return true;
    }


    public class DeploymentNestedImpl<N> extends ResourceTemplateFluentImpl<KafkaBridgeTemplateFluent.DeploymentNested<N>> implements KafkaBridgeTemplateFluent.DeploymentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ResourceTemplateBuilder builder;
    
            DeploymentNestedImpl(ResourceTemplate item){
                    this.builder = new ResourceTemplateBuilder(this, item);
            }
            DeploymentNestedImpl(){
                    this.builder = new ResourceTemplateBuilder(this);
            }
    
    public N and(){
            return (N) KafkaBridgeTemplateFluentImpl.this.withDeployment(builder.build());
    }
    public N endDeployment(){
            return and();
    }

}
    public class PodNestedImpl<N> extends PodTemplateFluentImpl<KafkaBridgeTemplateFluent.PodNested<N>> implements KafkaBridgeTemplateFluent.PodNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PodTemplateBuilder builder;
    
            PodNestedImpl(PodTemplate item){
                    this.builder = new PodTemplateBuilder(this, item);
            }
            PodNestedImpl(){
                    this.builder = new PodTemplateBuilder(this);
            }
    
    public N and(){
            return (N) KafkaBridgeTemplateFluentImpl.this.withPod(builder.build());
    }
    public N endPod(){
            return and();
    }

}
    public class ApiServiceNestedImpl<N> extends ResourceTemplateFluentImpl<KafkaBridgeTemplateFluent.ApiServiceNested<N>> implements KafkaBridgeTemplateFluent.ApiServiceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ResourceTemplateBuilder builder;
    
            ApiServiceNestedImpl(ResourceTemplate item){
                    this.builder = new ResourceTemplateBuilder(this, item);
            }
            ApiServiceNestedImpl(){
                    this.builder = new ResourceTemplateBuilder(this);
            }
    
    public N and(){
            return (N) KafkaBridgeTemplateFluentImpl.this.withApiService(builder.build());
    }
    public N endApiService(){
            return and();
    }

}
    public class PodDisruptionBudgetNestedImpl<N> extends PodDisruptionBudgetTemplateFluentImpl<KafkaBridgeTemplateFluent.PodDisruptionBudgetNested<N>> implements KafkaBridgeTemplateFluent.PodDisruptionBudgetNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PodDisruptionBudgetTemplateBuilder builder;
    
            PodDisruptionBudgetNestedImpl(PodDisruptionBudgetTemplate item){
                    this.builder = new PodDisruptionBudgetTemplateBuilder(this, item);
            }
            PodDisruptionBudgetNestedImpl(){
                    this.builder = new PodDisruptionBudgetTemplateBuilder(this);
            }
    
    public N and(){
            return (N) KafkaBridgeTemplateFluentImpl.this.withPodDisruptionBudget(builder.build());
    }
    public N endPodDisruptionBudget(){
            return and();
    }

}
    public class BridgeContainerNestedImpl<N> extends ContainerTemplateFluentImpl<KafkaBridgeTemplateFluent.BridgeContainerNested<N>> implements KafkaBridgeTemplateFluent.BridgeContainerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ContainerTemplateBuilder builder;
    
            BridgeContainerNestedImpl(ContainerTemplate item){
                    this.builder = new ContainerTemplateBuilder(this, item);
            }
            BridgeContainerNestedImpl(){
                    this.builder = new ContainerTemplateBuilder(this);
            }
    
    public N and(){
            return (N) KafkaBridgeTemplateFluentImpl.this.withBridgeContainer(builder.build());
    }
    public N endBridgeContainer(){
            return and();
    }

}


}
