package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ExternalServiceTemplateBuilder extends ExternalServiceTemplateFluentImpl<ExternalServiceTemplateBuilder> implements VisitableBuilder<ExternalServiceTemplate,ExternalServiceTemplateBuilder>{

    ExternalServiceTemplateFluent<?> fluent;
    Boolean validationEnabled;

    public ExternalServiceTemplateBuilder(){
            this(true);
    }
    public ExternalServiceTemplateBuilder(Boolean validationEnabled){
            this(new ExternalServiceTemplate(), validationEnabled);
    }
    public ExternalServiceTemplateBuilder(ExternalServiceTemplateFluent<?> fluent){
            this(fluent, true);
    }
    public ExternalServiceTemplateBuilder(ExternalServiceTemplateFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ExternalServiceTemplate(), validationEnabled);
    }
    public ExternalServiceTemplateBuilder(ExternalServiceTemplateFluent<?> fluent,ExternalServiceTemplate instance){
            this(fluent, instance, true);
    }
    public ExternalServiceTemplateBuilder(ExternalServiceTemplateFluent<?> fluent,ExternalServiceTemplate instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withMetadata(instance.getMetadata());

            fluent.withExternalTrafficPolicy(instance.getExternalTrafficPolicy());

            fluent.withLoadBalancerSourceRanges(instance.getLoadBalancerSourceRanges());

            this.validationEnabled = validationEnabled; 
    }
    public ExternalServiceTemplateBuilder(ExternalServiceTemplate instance){
            this(instance,true);
    }
    public ExternalServiceTemplateBuilder(ExternalServiceTemplate instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withMetadata(instance.getMetadata());

            this.withExternalTrafficPolicy(instance.getExternalTrafficPolicy());

            this.withLoadBalancerSourceRanges(instance.getLoadBalancerSourceRanges());

            this.validationEnabled = validationEnabled; 
    }

    public ExternalServiceTemplate build(){
            ExternalServiceTemplate buildable = new ExternalServiceTemplate();
            buildable.setMetadata(fluent.getMetadata());
            buildable.setExternalTrafficPolicy(fluent.getExternalTrafficPolicy());
            buildable.setLoadBalancerSourceRanges(fluent.getLoadBalancerSourceRanges());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ExternalServiceTemplateBuilder that = (ExternalServiceTemplateBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
