package io.strimzi.api.kafka.model.storage;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.LinkedHashMap;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface PersistentClaimStorageFluent<A extends PersistentClaimStorageFluent<A>> extends Fluent<A>{


    public String getSize();
    public A withSize(String size);
    public Boolean hasSize();
    public A withNewSize(String arg1);
    public A withNewSize(StringBuilder arg1);
    public A withNewSize(StringBuffer arg1);
    public String getStorageClass();
    public A withStorageClass(String storageClass);
    public Boolean hasStorageClass();
    public A withNewStorageClass(String arg1);
    public A withNewStorageClass(StringBuilder arg1);
    public A withNewStorageClass(StringBuffer arg1);
    public A addToSelector(String key,String value);
    public A addToSelector(Map<String,String> map);
    public A removeFromSelector(String key);
    public A removeFromSelector(Map<String,String> map);
    public Map<String,String> getSelector();
    public A withSelector(Map<String,String> selector);
    public Boolean hasSelector();
    public boolean isDeleteClaim();
    public A withDeleteClaim(boolean deleteClaim);
    public Boolean hasDeleteClaim();
    public A addToOverrides(int index,PersistentClaimStorageOverride item);
    public A setToOverrides(int index,PersistentClaimStorageOverride item);
    public A addToOverrides(PersistentClaimStorageOverride... items);
    public A addAllToOverrides(Collection<PersistentClaimStorageOverride> items);
    public A removeFromOverrides(PersistentClaimStorageOverride... items);
    public A removeAllFromOverrides(Collection<PersistentClaimStorageOverride> items);
    public A removeMatchingFromOverrides(io.fabric8.kubernetes.api.builder.Predicate<PersistentClaimStorageOverrideBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildOverrides instead.
 * @return The buildable object.
 */
@Deprecated public List<PersistentClaimStorageOverride> getOverrides();
    public List<PersistentClaimStorageOverride> buildOverrides();
    public PersistentClaimStorageOverride buildOverride(int index);
    public PersistentClaimStorageOverride buildFirstOverride();
    public PersistentClaimStorageOverride buildLastOverride();
    public PersistentClaimStorageOverride buildMatchingOverride(io.fabric8.kubernetes.api.builder.Predicate<PersistentClaimStorageOverrideBuilder> predicate);
    public Boolean hasMatchingOverride(io.fabric8.kubernetes.api.builder.Predicate<PersistentClaimStorageOverrideBuilder> predicate);
    public A withOverrides(List<PersistentClaimStorageOverride> overrides);
    public A withOverrides(PersistentClaimStorageOverride... overrides);
    public Boolean hasOverrides();
    public PersistentClaimStorageFluent.OverridesNested<A> addNewOverride();
    public PersistentClaimStorageFluent.OverridesNested<A> addNewOverrideLike(PersistentClaimStorageOverride item);
    public PersistentClaimStorageFluent.OverridesNested<A> setNewOverrideLike(int index,PersistentClaimStorageOverride item);
    public PersistentClaimStorageFluent.OverridesNested<A> editOverride(int index);
    public PersistentClaimStorageFluent.OverridesNested<A> editFirstOverride();
    public PersistentClaimStorageFluent.OverridesNested<A> editLastOverride();
    public PersistentClaimStorageFluent.OverridesNested<A> editMatchingOverride(io.fabric8.kubernetes.api.builder.Predicate<PersistentClaimStorageOverrideBuilder> predicate);
    public Integer getId();
    public A withId(Integer id);
    public Boolean hasId();

    public interface OverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PersistentClaimStorageOverrideFluent<PersistentClaimStorageFluent.OverridesNested<N>>{

        
    public N and();    public N endOverride();
}


}
