package io.strimzi.api.kafka.model.storage;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PersistentClaimStorageBuilder extends PersistentClaimStorageFluentImpl<PersistentClaimStorageBuilder> implements VisitableBuilder<PersistentClaimStorage,PersistentClaimStorageBuilder>{

    PersistentClaimStorageFluent<?> fluent;
    Boolean validationEnabled;

    public PersistentClaimStorageBuilder(){
            this(true);
    }
    public PersistentClaimStorageBuilder(Boolean validationEnabled){
            this(new PersistentClaimStorage(), validationEnabled);
    }
    public PersistentClaimStorageBuilder(PersistentClaimStorageFluent<?> fluent){
            this(fluent, true);
    }
    public PersistentClaimStorageBuilder(PersistentClaimStorageFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new PersistentClaimStorage(), validationEnabled);
    }
    public PersistentClaimStorageBuilder(PersistentClaimStorageFluent<?> fluent,PersistentClaimStorage instance){
            this(fluent, instance, true);
    }
    public PersistentClaimStorageBuilder(PersistentClaimStorageFluent<?> fluent,PersistentClaimStorage instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withSize(instance.getSize());

            fluent.withStorageClass(instance.getStorageClass());

            fluent.withSelector(instance.getSelector());

            fluent.withDeleteClaim(instance.isDeleteClaim());

            fluent.withOverrides(instance.getOverrides());

            fluent.withId(instance.getId());

            this.validationEnabled = validationEnabled; 
    }
    public PersistentClaimStorageBuilder(PersistentClaimStorage instance){
            this(instance,true);
    }
    public PersistentClaimStorageBuilder(PersistentClaimStorage instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withSize(instance.getSize());

            this.withStorageClass(instance.getStorageClass());

            this.withSelector(instance.getSelector());

            this.withDeleteClaim(instance.isDeleteClaim());

            this.withOverrides(instance.getOverrides());

            this.withId(instance.getId());

            this.validationEnabled = validationEnabled; 
    }

    public PersistentClaimStorage build(){
            PersistentClaimStorage buildable = new PersistentClaimStorage();
            buildable.setSize(fluent.getSize());
            buildable.setStorageClass(fluent.getStorageClass());
            buildable.setSelector(fluent.getSelector());
            buildable.setDeleteClaim(fluent.isDeleteClaim());
            buildable.setOverrides(fluent.getOverrides());
            buildable.setId(fluent.getId());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PersistentClaimStorageBuilder that = (PersistentClaimStorageBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
