package io.strimzi.api.kafka.model.storage;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface JbodStorageFluent<A extends JbodStorageFluent<A>> extends Fluent<A>{


    public A addToVolumes(VisitableBuilder<? extends SingleVolumeStorage,?> builder);
    public A addToVolumes(int index,VisitableBuilder<? extends SingleVolumeStorage,?> builder);
    public A addToVolumes(int index,SingleVolumeStorage item);
    public A setToVolumes(int index,SingleVolumeStorage item);
    public A addToVolumes(SingleVolumeStorage... items);
    public A addAllToVolumes(Collection<SingleVolumeStorage> items);
    public A removeFromVolumes(VisitableBuilder<? extends SingleVolumeStorage,?> builder);
    public A removeFromVolumes(SingleVolumeStorage... items);
    public A removeAllFromVolumes(Collection<SingleVolumeStorage> items);
    
/**
 * This method has been deprecated, please use method buildVolumes instead.
 * @return The buildable object.
 */
@Deprecated public List<SingleVolumeStorage> getVolumes();
    public List<SingleVolumeStorage> buildVolumes();
    public SingleVolumeStorage buildVolume(int index);
    public SingleVolumeStorage buildFirstVolume();
    public SingleVolumeStorage buildLastVolume();
    public SingleVolumeStorage buildMatchingVolume(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends SingleVolumeStorage,?>> predicate);
    public Boolean hasMatchingVolume(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends SingleVolumeStorage,?>> predicate);
    public A withVolumes(List<SingleVolumeStorage> volumes);
    public A withVolumes(SingleVolumeStorage... volumes);
    public Boolean hasVolumes();
    public A addToPersistentClaimStorageVolumes(int index,PersistentClaimStorage item);
    public A setToPersistentClaimStorageVolumes(int index,PersistentClaimStorage item);
    public A addToPersistentClaimStorageVolumes(PersistentClaimStorage... items);
    public A addAllToPersistentClaimStorageVolumes(Collection<PersistentClaimStorage> items);
    public A removeFromPersistentClaimStorageVolumes(PersistentClaimStorage... items);
    public A removeAllFromPersistentClaimStorageVolumes(Collection<PersistentClaimStorage> items);
    public A removeMatchingFromPersistentClaimStorageVolumes(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends SingleVolumeStorage,?>> predicate);
    public JbodStorageFluent.PersistentClaimStorageVolumesNested<A> setNewPersistentClaimStorageVolumeLike(int index,PersistentClaimStorage item);
    public JbodStorageFluent.PersistentClaimStorageVolumesNested<A> addNewPersistentClaimStorageVolume();
    public JbodStorageFluent.PersistentClaimStorageVolumesNested<A> addNewPersistentClaimStorageVolumeLike(PersistentClaimStorage item);
    public A addToEphemeralStorageVolumes(int index,EphemeralStorage item);
    public A setToEphemeralStorageVolumes(int index,EphemeralStorage item);
    public A addToEphemeralStorageVolumes(EphemeralStorage... items);
    public A addAllToEphemeralStorageVolumes(Collection<EphemeralStorage> items);
    public A removeFromEphemeralStorageVolumes(EphemeralStorage... items);
    public A removeAllFromEphemeralStorageVolumes(Collection<EphemeralStorage> items);
    public A removeMatchingFromEphemeralStorageVolumes(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends SingleVolumeStorage,?>> predicate);
    public JbodStorageFluent.EphemeralStorageVolumesNested<A> setNewEphemeralStorageVolumeLike(int index,EphemeralStorage item);
    public JbodStorageFluent.EphemeralStorageVolumesNested<A> addNewEphemeralStorageVolume();
    public JbodStorageFluent.EphemeralStorageVolumesNested<A> addNewEphemeralStorageVolumeLike(EphemeralStorage item);

    public interface PersistentClaimStorageVolumesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PersistentClaimStorageFluent<JbodStorageFluent.PersistentClaimStorageVolumesNested<N>>{

        
    public N and();    public N endPersistentClaimStorageVolume();
}
    public interface EphemeralStorageVolumesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,EphemeralStorageFluent<JbodStorageFluent.EphemeralStorageVolumesNested<N>>{

        
    public N and();    public N endEphemeralStorageVolume();
}


}
