package io.strimzi.api.kafka.model.status;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class ListenerStatusFluentImpl<A extends ListenerStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ListenerStatusFluent<A>{

    private String type;
    private List<ListenerAddressBuilder> addresses;

    public ListenerStatusFluentImpl(){
    }
    public ListenerStatusFluentImpl(ListenerStatus instance){
            this.withType(instance.getType());

            this.withAddresses(instance.getAddresses());

    }

    public String getType(){
            return this.type;
    }

    public A withType(String type){
            this.type=type; return (A) this;
    }

    public Boolean hasType(){
            return this.type != null;
    }

    public A withNewType(String arg1){
            return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuilder arg1){
            return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuffer arg1){
            return (A)withType(new String(arg1));
    }

    public A addToAddresses(int index,ListenerAddress item){
            if (this.addresses == null) {this.addresses = new ArrayList<ListenerAddressBuilder>();}
            ListenerAddressBuilder builder = new ListenerAddressBuilder(item);_visitables.get("addresses").add(index >= 0 ? index : _visitables.get("addresses").size(), builder);this.addresses.add(index >= 0 ? index : addresses.size(), builder); return (A)this;
    }

    public A setToAddresses(int index,ListenerAddress item){
            if (this.addresses == null) {this.addresses = new ArrayList<ListenerAddressBuilder>();}
            ListenerAddressBuilder builder = new ListenerAddressBuilder(item);
            if (index < 0 || index >= _visitables.get("addresses").size()) { _visitables.get("addresses").add(builder); } else { _visitables.get("addresses").set(index, builder);}
            if (index < 0 || index >= addresses.size()) { addresses.add(builder); } else { addresses.set(index, builder);}
             return (A)this;
    }

    public A addToAddresses(ListenerAddress... items){
            if (this.addresses == null) {this.addresses = new ArrayList<ListenerAddressBuilder>();}
            for (ListenerAddress item : items) {ListenerAddressBuilder builder = new ListenerAddressBuilder(item);_visitables.get("addresses").add(builder);this.addresses.add(builder);} return (A)this;
    }

    public A addAllToAddresses(Collection<ListenerAddress> items){
            if (this.addresses == null) {this.addresses = new ArrayList<ListenerAddressBuilder>();}
            for (ListenerAddress item : items) {ListenerAddressBuilder builder = new ListenerAddressBuilder(item);_visitables.get("addresses").add(builder);this.addresses.add(builder);} return (A)this;
    }

    public A removeFromAddresses(ListenerAddress... items){
            for (ListenerAddress item : items) {ListenerAddressBuilder builder = new ListenerAddressBuilder(item);_visitables.get("addresses").remove(builder);if (this.addresses != null) {this.addresses.remove(builder);}} return (A)this;
    }

    public A removeAllFromAddresses(Collection<ListenerAddress> items){
            for (ListenerAddress item : items) {ListenerAddressBuilder builder = new ListenerAddressBuilder(item);_visitables.get("addresses").remove(builder);if (this.addresses != null) {this.addresses.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromAddresses(io.fabric8.kubernetes.api.builder.Predicate<ListenerAddressBuilder> predicate){
            if (addresses == null) return (A) this;
            final Iterator<ListenerAddressBuilder> each = addresses.iterator();
            final List visitables = _visitables.get("addresses");
            while (each.hasNext()) {
              ListenerAddressBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildAddresses instead.
 * @return The buildable object.
 */
@Deprecated public List<ListenerAddress> getAddresses(){
            return build(addresses);
    }

    public List<ListenerAddress> buildAddresses(){
            return build(addresses);
    }

    public ListenerAddress buildAddress(int index){
            return this.addresses.get(index).build();
    }

    public ListenerAddress buildFirstAddress(){
            return this.addresses.get(0).build();
    }

    public ListenerAddress buildLastAddress(){
            return this.addresses.get(addresses.size() - 1).build();
    }

    public ListenerAddress buildMatchingAddress(io.fabric8.kubernetes.api.builder.Predicate<ListenerAddressBuilder> predicate){
            for (ListenerAddressBuilder item: addresses) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingAddress(io.fabric8.kubernetes.api.builder.Predicate<ListenerAddressBuilder> predicate){
            for (ListenerAddressBuilder item: addresses) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withAddresses(List<ListenerAddress> addresses){
            if (this.addresses != null) { _visitables.get("addresses").removeAll(this.addresses);}
            if (addresses != null) {this.addresses = new ArrayList<ListenerAddressBuilder>(); for (ListenerAddress item : addresses){this.addToAddresses(item);}} else { this.addresses = null;} return (A) this;
    }

    public A withAddresses(ListenerAddress... addresses){
            if (this.addresses != null) {this.addresses.clear();}
            if (addresses != null) {for (ListenerAddress item :addresses){ this.addToAddresses(item);}} return (A) this;
    }

    public Boolean hasAddresses(){
            return addresses != null && !addresses.isEmpty();
    }

    public ListenerStatusFluent.AddressesNested<A> addNewAddress(){
            return new AddressesNestedImpl();
    }

    public ListenerStatusFluent.AddressesNested<A> addNewAddressLike(ListenerAddress item){
            return new AddressesNestedImpl(-1, item);
    }

    public ListenerStatusFluent.AddressesNested<A> setNewAddressLike(int index,ListenerAddress item){
            return new AddressesNestedImpl(index, item);
    }

    public ListenerStatusFluent.AddressesNested<A> editAddress(int index){
            if (addresses.size() <= index) throw new RuntimeException("Can't edit addresses. Index exceeds size.");
            return setNewAddressLike(index, buildAddress(index));
    }

    public ListenerStatusFluent.AddressesNested<A> editFirstAddress(){
            if (addresses.size() == 0) throw new RuntimeException("Can't edit first addresses. The list is empty.");
            return setNewAddressLike(0, buildAddress(0));
    }

    public ListenerStatusFluent.AddressesNested<A> editLastAddress(){
            int index = addresses.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last addresses. The list is empty.");
            return setNewAddressLike(index, buildAddress(index));
    }

    public ListenerStatusFluent.AddressesNested<A> editMatchingAddress(io.fabric8.kubernetes.api.builder.Predicate<ListenerAddressBuilder> predicate){
            int index = -1;
            for (int i=0;i<addresses.size();i++) { 
            if (predicate.apply(addresses.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching addresses. No match found.");
            return setNewAddressLike(index, buildAddress(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            ListenerStatusFluentImpl that = (ListenerStatusFluentImpl) o;
            if (type != null ? !type.equals(that.type) :that.type != null) return false;
            if (addresses != null ? !addresses.equals(that.addresses) :that.addresses != null) return false;
            return true;
    }


    public class AddressesNestedImpl<N> extends ListenerAddressFluentImpl<ListenerStatusFluent.AddressesNested<N>> implements ListenerStatusFluent.AddressesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ListenerAddressBuilder builder;
        private final int index;
    
            AddressesNestedImpl(int index,ListenerAddress item){
                    this.index = index;
                    this.builder = new ListenerAddressBuilder(this, item);
            }
            AddressesNestedImpl(){
                    this.index = -1;
                    this.builder = new ListenerAddressBuilder(this);
            }
    
    public N and(){
            return (N) ListenerStatusFluentImpl.this.setToAddresses(index, builder.build());
    }
    public N endAddress(){
            return and();
    }

}


}
