package io.strimzi.api.kafka.model.status;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaUserStatusBuilder extends KafkaUserStatusFluentImpl<KafkaUserStatusBuilder> implements VisitableBuilder<KafkaUserStatus,KafkaUserStatusBuilder>{

    KafkaUserStatusFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaUserStatusBuilder(){
            this(true);
    }
    public KafkaUserStatusBuilder(Boolean validationEnabled){
            this(new KafkaUserStatus(), validationEnabled);
    }
    public KafkaUserStatusBuilder(KafkaUserStatusFluent<?> fluent){
            this(fluent, true);
    }
    public KafkaUserStatusBuilder(KafkaUserStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new KafkaUserStatus(), validationEnabled);
    }
    public KafkaUserStatusBuilder(KafkaUserStatusFluent<?> fluent,KafkaUserStatus instance){
            this(fluent, instance, true);
    }
    public KafkaUserStatusBuilder(KafkaUserStatusFluent<?> fluent,KafkaUserStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withUsername(instance.getUsername());

            fluent.withSecret(instance.getSecret());

            fluent.withConditions(instance.getConditions());

            fluent.withObservedGeneration(instance.getObservedGeneration());

            this.validationEnabled = validationEnabled; 
    }
    public KafkaUserStatusBuilder(KafkaUserStatus instance){
            this(instance,true);
    }
    public KafkaUserStatusBuilder(KafkaUserStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withUsername(instance.getUsername());

            this.withSecret(instance.getSecret());

            this.withConditions(instance.getConditions());

            this.withObservedGeneration(instance.getObservedGeneration());

            this.validationEnabled = validationEnabled; 
    }

    public KafkaUserStatus build(){
            KafkaUserStatus buildable = new KafkaUserStatus();
            buildable.setConditions(fluent.getConditions());
            buildable.setObservedGeneration(fluent.getObservedGeneration());
            buildable.setUsername(fluent.getUsername());
            buildable.setSecret(fluent.getSecret());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KafkaUserStatusBuilder that = (KafkaUserStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
