package io.strimzi.api.kafka.model.status;

import java.lang.StringBuffer;
import java.lang.StringBuilder;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class KafkaConnectS2IstatusFluentImpl<A extends KafkaConnectS2IstatusFluent<A>> extends KafkaConnectStatusFluentImpl<A> implements KafkaConnectS2IstatusFluent<A>{

    private String buildConfigName;

    public KafkaConnectS2IstatusFluentImpl(){
    }
    public KafkaConnectS2IstatusFluentImpl(KafkaConnectS2Istatus instance){
            this.withBuildConfigName(instance.getBuildConfigName());

            this.withUrl(instance.getUrl());

            this.withConditions(instance.getConditions());

            this.withObservedGeneration(instance.getObservedGeneration());

    }

    public String getBuildConfigName(){
            return this.buildConfigName;
    }

    public A withBuildConfigName(String buildConfigName){
            this.buildConfigName=buildConfigName; return (A) this;
    }

    public Boolean hasBuildConfigName(){
            return this.buildConfigName != null;
    }

    public A withNewBuildConfigName(String arg1){
            return (A)withBuildConfigName(new String(arg1));
    }

    public A withNewBuildConfigName(StringBuilder arg1){
            return (A)withBuildConfigName(new String(arg1));
    }

    public A withNewBuildConfigName(StringBuffer arg1){
            return (A)withBuildConfigName(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KafkaConnectS2IstatusFluentImpl that = (KafkaConnectS2IstatusFluentImpl) o;
            if (buildConfigName != null ? !buildConfigName.equals(that.buildConfigName) :that.buildConfigName != null) return false;
            return true;
    }




}
