package io.strimzi.api.kafka.model.status;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaConnectS2IstatusBuilder extends KafkaConnectS2IstatusFluentImpl<KafkaConnectS2IstatusBuilder> implements VisitableBuilder<KafkaConnectS2Istatus,KafkaConnectS2IstatusBuilder>{

    KafkaConnectS2IstatusFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaConnectS2IstatusBuilder(){
            this(true);
    }
    public KafkaConnectS2IstatusBuilder(Boolean validationEnabled){
            this(new KafkaConnectS2Istatus(), validationEnabled);
    }
    public KafkaConnectS2IstatusBuilder(KafkaConnectS2IstatusFluent<?> fluent){
            this(fluent, true);
    }
    public KafkaConnectS2IstatusBuilder(KafkaConnectS2IstatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new KafkaConnectS2Istatus(), validationEnabled);
    }
    public KafkaConnectS2IstatusBuilder(KafkaConnectS2IstatusFluent<?> fluent,KafkaConnectS2Istatus instance){
            this(fluent, instance, true);
    }
    public KafkaConnectS2IstatusBuilder(KafkaConnectS2IstatusFluent<?> fluent,KafkaConnectS2Istatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withBuildConfigName(instance.getBuildConfigName());

            fluent.withUrl(instance.getUrl());

            fluent.withConditions(instance.getConditions());

            fluent.withObservedGeneration(instance.getObservedGeneration());

            this.validationEnabled = validationEnabled; 
    }
    public KafkaConnectS2IstatusBuilder(KafkaConnectS2Istatus instance){
            this(instance,true);
    }
    public KafkaConnectS2IstatusBuilder(KafkaConnectS2Istatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withBuildConfigName(instance.getBuildConfigName());

            this.withUrl(instance.getUrl());

            this.withConditions(instance.getConditions());

            this.withObservedGeneration(instance.getObservedGeneration());

            this.validationEnabled = validationEnabled; 
    }

    public KafkaConnectS2Istatus build(){
            KafkaConnectS2Istatus buildable = new KafkaConnectS2Istatus();
            buildable.setConditions(fluent.getConditions());
            buildable.setObservedGeneration(fluent.getObservedGeneration());
            buildable.setUrl(fluent.getUrl());
            buildable.setBuildConfigName(fluent.getBuildConfigName());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KafkaConnectS2IstatusBuilder that = (KafkaConnectS2IstatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
