package io.strimzi.api.kafka.model.status;

import java.lang.StringBuffer;
import java.lang.StringBuilder;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class KafkaBridgeStatusFluentImpl<A extends KafkaBridgeStatusFluent<A>> extends StatusFluentImpl<A> implements KafkaBridgeStatusFluent<A>{

    private String url;

    public KafkaBridgeStatusFluentImpl(){
    }
    public KafkaBridgeStatusFluentImpl(KafkaBridgeStatus instance){
            this.withUrl(instance.getUrl());

            this.withConditions(instance.getConditions());

            this.withObservedGeneration(instance.getObservedGeneration());

    }

    public String getUrl(){
            return this.url;
    }

    public A withUrl(String url){
            this.url=url; return (A) this;
    }

    public Boolean hasUrl(){
            return this.url != null;
    }

    public A withNewUrl(String arg1){
            return (A)withUrl(new String(arg1));
    }

    public A withNewUrl(StringBuilder arg1){
            return (A)withUrl(new String(arg1));
    }

    public A withNewUrl(StringBuffer arg1){
            return (A)withUrl(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KafkaBridgeStatusFluentImpl that = (KafkaBridgeStatusFluentImpl) o;
            if (url != null ? !url.equals(that.url) :that.url != null) return false;
            return true;
    }




}
