package io.strimzi.api.kafka.model.status;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ConditionBuilder extends ConditionFluentImpl<ConditionBuilder> implements VisitableBuilder<Condition,ConditionBuilder>{

    ConditionFluent<?> fluent;
    Boolean validationEnabled;

    public ConditionBuilder(){
            this(true);
    }
    public ConditionBuilder(Boolean validationEnabled){
            this(new Condition(), validationEnabled);
    }
    public ConditionBuilder(ConditionFluent<?> fluent){
            this(fluent, true);
    }
    public ConditionBuilder(ConditionFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Condition(), validationEnabled);
    }
    public ConditionBuilder(ConditionFluent<?> fluent,Condition instance){
            this(fluent, instance, true);
    }
    public ConditionBuilder(ConditionFluent<?> fluent,Condition instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withStatus(instance.getStatus());

            fluent.withReason(instance.getReason());

            fluent.withMessage(instance.getMessage());

            fluent.withType(instance.getType());

            fluent.withLastTransitionTime(instance.getLastTransitionTime());

            this.validationEnabled = validationEnabled; 
    }
    public ConditionBuilder(Condition instance){
            this(instance,true);
    }
    public ConditionBuilder(Condition instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withStatus(instance.getStatus());

            this.withReason(instance.getReason());

            this.withMessage(instance.getMessage());

            this.withType(instance.getType());

            this.withLastTransitionTime(instance.getLastTransitionTime());

            this.validationEnabled = validationEnabled; 
    }

    public Condition build(){
            Condition buildable = new Condition();
            buildable.setStatus(fluent.getStatus());
            buildable.setReason(fluent.getReason());
            buildable.setMessage(fluent.getMessage());
            buildable.setType(fluent.getType());
            buildable.setLastTransitionTime(fluent.getLastTransitionTime());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ConditionBuilder that = (ConditionBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
