package io.strimzi.api.kafka.model.listener;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class RouteListenerOverrideFluentImpl<A extends RouteListenerOverrideFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements RouteListenerOverrideFluent<A>{

    private RouteListenerBootstrapOverrideBuilder bootstrap;
    private List<RouteListenerBrokerOverrideBuilder> brokers;

    public RouteListenerOverrideFluentImpl(){
    }
    public RouteListenerOverrideFluentImpl(RouteListenerOverride instance){
            this.withBootstrap(instance.getBootstrap());

            this.withBrokers(instance.getBrokers());

    }

    
/**
 * This method has been deprecated, please use method buildBootstrap instead.
 * @return The buildable object.
 */
@Deprecated public RouteListenerBootstrapOverride getBootstrap(){
            return this.bootstrap!=null?this.bootstrap.build():null;
    }

    public RouteListenerBootstrapOverride buildBootstrap(){
            return this.bootstrap!=null?this.bootstrap.build():null;
    }

    public A withBootstrap(RouteListenerBootstrapOverride bootstrap){
            _visitables.get("bootstrap").remove(this.bootstrap);
            if (bootstrap!=null){ this.bootstrap= new RouteListenerBootstrapOverrideBuilder(bootstrap); _visitables.get("bootstrap").add(this.bootstrap);} return (A) this;
    }

    public Boolean hasBootstrap(){
            return this.bootstrap != null;
    }

    public RouteListenerOverrideFluent.BootstrapNested<A> withNewBootstrap(){
            return new BootstrapNestedImpl();
    }

    public RouteListenerOverrideFluent.BootstrapNested<A> withNewBootstrapLike(RouteListenerBootstrapOverride item){
            return new BootstrapNestedImpl(item);
    }

    public RouteListenerOverrideFluent.BootstrapNested<A> editBootstrap(){
            return withNewBootstrapLike(getBootstrap());
    }

    public RouteListenerOverrideFluent.BootstrapNested<A> editOrNewBootstrap(){
            return withNewBootstrapLike(getBootstrap() != null ? getBootstrap(): new RouteListenerBootstrapOverrideBuilder().build());
    }

    public RouteListenerOverrideFluent.BootstrapNested<A> editOrNewBootstrapLike(RouteListenerBootstrapOverride item){
            return withNewBootstrapLike(getBootstrap() != null ? getBootstrap(): item);
    }

    public A addToBrokers(int index,RouteListenerBrokerOverride item){
            if (this.brokers == null) {this.brokers = new ArrayList<RouteListenerBrokerOverrideBuilder>();}
            RouteListenerBrokerOverrideBuilder builder = new RouteListenerBrokerOverrideBuilder(item);_visitables.get("brokers").add(index >= 0 ? index : _visitables.get("brokers").size(), builder);this.brokers.add(index >= 0 ? index : brokers.size(), builder); return (A)this;
    }

    public A setToBrokers(int index,RouteListenerBrokerOverride item){
            if (this.brokers == null) {this.brokers = new ArrayList<RouteListenerBrokerOverrideBuilder>();}
            RouteListenerBrokerOverrideBuilder builder = new RouteListenerBrokerOverrideBuilder(item);
            if (index < 0 || index >= _visitables.get("brokers").size()) { _visitables.get("brokers").add(builder); } else { _visitables.get("brokers").set(index, builder);}
            if (index < 0 || index >= brokers.size()) { brokers.add(builder); } else { brokers.set(index, builder);}
             return (A)this;
    }

    public A addToBrokers(RouteListenerBrokerOverride... items){
            if (this.brokers == null) {this.brokers = new ArrayList<RouteListenerBrokerOverrideBuilder>();}
            for (RouteListenerBrokerOverride item : items) {RouteListenerBrokerOverrideBuilder builder = new RouteListenerBrokerOverrideBuilder(item);_visitables.get("brokers").add(builder);this.brokers.add(builder);} return (A)this;
    }

    public A addAllToBrokers(Collection<RouteListenerBrokerOverride> items){
            if (this.brokers == null) {this.brokers = new ArrayList<RouteListenerBrokerOverrideBuilder>();}
            for (RouteListenerBrokerOverride item : items) {RouteListenerBrokerOverrideBuilder builder = new RouteListenerBrokerOverrideBuilder(item);_visitables.get("brokers").add(builder);this.brokers.add(builder);} return (A)this;
    }

    public A removeFromBrokers(RouteListenerBrokerOverride... items){
            for (RouteListenerBrokerOverride item : items) {RouteListenerBrokerOverrideBuilder builder = new RouteListenerBrokerOverrideBuilder(item);_visitables.get("brokers").remove(builder);if (this.brokers != null) {this.brokers.remove(builder);}} return (A)this;
    }

    public A removeAllFromBrokers(Collection<RouteListenerBrokerOverride> items){
            for (RouteListenerBrokerOverride item : items) {RouteListenerBrokerOverrideBuilder builder = new RouteListenerBrokerOverrideBuilder(item);_visitables.get("brokers").remove(builder);if (this.brokers != null) {this.brokers.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromBrokers(io.fabric8.kubernetes.api.builder.Predicate<RouteListenerBrokerOverrideBuilder> predicate){
            if (brokers == null) return (A) this;
            final Iterator<RouteListenerBrokerOverrideBuilder> each = brokers.iterator();
            final List visitables = _visitables.get("brokers");
            while (each.hasNext()) {
              RouteListenerBrokerOverrideBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildBrokers instead.
 * @return The buildable object.
 */
@Deprecated public List<RouteListenerBrokerOverride> getBrokers(){
            return build(brokers);
    }

    public List<RouteListenerBrokerOverride> buildBrokers(){
            return build(brokers);
    }

    public RouteListenerBrokerOverride buildBroker(int index){
            return this.brokers.get(index).build();
    }

    public RouteListenerBrokerOverride buildFirstBroker(){
            return this.brokers.get(0).build();
    }

    public RouteListenerBrokerOverride buildLastBroker(){
            return this.brokers.get(brokers.size() - 1).build();
    }

    public RouteListenerBrokerOverride buildMatchingBroker(io.fabric8.kubernetes.api.builder.Predicate<RouteListenerBrokerOverrideBuilder> predicate){
            for (RouteListenerBrokerOverrideBuilder item: brokers) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingBroker(io.fabric8.kubernetes.api.builder.Predicate<RouteListenerBrokerOverrideBuilder> predicate){
            for (RouteListenerBrokerOverrideBuilder item: brokers) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withBrokers(List<RouteListenerBrokerOverride> brokers){
            if (this.brokers != null) { _visitables.get("brokers").removeAll(this.brokers);}
            if (brokers != null) {this.brokers = new ArrayList<RouteListenerBrokerOverrideBuilder>(); for (RouteListenerBrokerOverride item : brokers){this.addToBrokers(item);}} else { this.brokers = null;} return (A) this;
    }

    public A withBrokers(RouteListenerBrokerOverride... brokers){
            if (this.brokers != null) {this.brokers.clear();}
            if (brokers != null) {for (RouteListenerBrokerOverride item :brokers){ this.addToBrokers(item);}} return (A) this;
    }

    public Boolean hasBrokers(){
            return brokers != null && !brokers.isEmpty();
    }

    public RouteListenerOverrideFluent.BrokersNested<A> addNewBroker(){
            return new BrokersNestedImpl();
    }

    public RouteListenerOverrideFluent.BrokersNested<A> addNewBrokerLike(RouteListenerBrokerOverride item){
            return new BrokersNestedImpl(-1, item);
    }

    public RouteListenerOverrideFluent.BrokersNested<A> setNewBrokerLike(int index,RouteListenerBrokerOverride item){
            return new BrokersNestedImpl(index, item);
    }

    public RouteListenerOverrideFluent.BrokersNested<A> editBroker(int index){
            if (brokers.size() <= index) throw new RuntimeException("Can't edit brokers. Index exceeds size.");
            return setNewBrokerLike(index, buildBroker(index));
    }

    public RouteListenerOverrideFluent.BrokersNested<A> editFirstBroker(){
            if (brokers.size() == 0) throw new RuntimeException("Can't edit first brokers. The list is empty.");
            return setNewBrokerLike(0, buildBroker(0));
    }

    public RouteListenerOverrideFluent.BrokersNested<A> editLastBroker(){
            int index = brokers.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last brokers. The list is empty.");
            return setNewBrokerLike(index, buildBroker(index));
    }

    public RouteListenerOverrideFluent.BrokersNested<A> editMatchingBroker(io.fabric8.kubernetes.api.builder.Predicate<RouteListenerBrokerOverrideBuilder> predicate){
            int index = -1;
            for (int i=0;i<brokers.size();i++) { 
            if (predicate.apply(brokers.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching brokers. No match found.");
            return setNewBrokerLike(index, buildBroker(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            RouteListenerOverrideFluentImpl that = (RouteListenerOverrideFluentImpl) o;
            if (bootstrap != null ? !bootstrap.equals(that.bootstrap) :that.bootstrap != null) return false;
            if (brokers != null ? !brokers.equals(that.brokers) :that.brokers != null) return false;
            return true;
    }


    public class BootstrapNestedImpl<N> extends RouteListenerBootstrapOverrideFluentImpl<RouteListenerOverrideFluent.BootstrapNested<N>> implements RouteListenerOverrideFluent.BootstrapNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final RouteListenerBootstrapOverrideBuilder builder;
    
            BootstrapNestedImpl(RouteListenerBootstrapOverride item){
                    this.builder = new RouteListenerBootstrapOverrideBuilder(this, item);
            }
            BootstrapNestedImpl(){
                    this.builder = new RouteListenerBootstrapOverrideBuilder(this);
            }
    
    public N and(){
            return (N) RouteListenerOverrideFluentImpl.this.withBootstrap(builder.build());
    }
    public N endBootstrap(){
            return and();
    }

}
    public class BrokersNestedImpl<N> extends RouteListenerBrokerOverrideFluentImpl<RouteListenerOverrideFluent.BrokersNested<N>> implements RouteListenerOverrideFluent.BrokersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final RouteListenerBrokerOverrideBuilder builder;
        private final int index;
    
            BrokersNestedImpl(int index,RouteListenerBrokerOverride item){
                    this.index = index;
                    this.builder = new RouteListenerBrokerOverrideBuilder(this, item);
            }
            BrokersNestedImpl(){
                    this.index = -1;
                    this.builder = new RouteListenerBrokerOverrideBuilder(this);
            }
    
    public N and(){
            return (N) RouteListenerOverrideFluentImpl.this.setToBrokers(index, builder.build());
    }
    public N endBroker(){
            return and();
    }

}


}
