package io.strimzi.api.kafka.model.listener;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RouteListenerBootstrapOverrideBuilder extends RouteListenerBootstrapOverrideFluentImpl<RouteListenerBootstrapOverrideBuilder> implements VisitableBuilder<RouteListenerBootstrapOverride,RouteListenerBootstrapOverrideBuilder>{

    RouteListenerBootstrapOverrideFluent<?> fluent;
    Boolean validationEnabled;

    public RouteListenerBootstrapOverrideBuilder(){
            this(true);
    }
    public RouteListenerBootstrapOverrideBuilder(Boolean validationEnabled){
            this(new RouteListenerBootstrapOverride(), validationEnabled);
    }
    public RouteListenerBootstrapOverrideBuilder(RouteListenerBootstrapOverrideFluent<?> fluent){
            this(fluent, true);
    }
    public RouteListenerBootstrapOverrideBuilder(RouteListenerBootstrapOverrideFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new RouteListenerBootstrapOverride(), validationEnabled);
    }
    public RouteListenerBootstrapOverrideBuilder(RouteListenerBootstrapOverrideFluent<?> fluent,RouteListenerBootstrapOverride instance){
            this(fluent, instance, true);
    }
    public RouteListenerBootstrapOverrideBuilder(RouteListenerBootstrapOverrideFluent<?> fluent,RouteListenerBootstrapOverride instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withHost(instance.getHost());

            fluent.withAddress(instance.getAddress());

            this.validationEnabled = validationEnabled; 
    }
    public RouteListenerBootstrapOverrideBuilder(RouteListenerBootstrapOverride instance){
            this(instance,true);
    }
    public RouteListenerBootstrapOverrideBuilder(RouteListenerBootstrapOverride instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withHost(instance.getHost());

            this.withAddress(instance.getAddress());

            this.validationEnabled = validationEnabled; 
    }

    public RouteListenerBootstrapOverride build(){
            RouteListenerBootstrapOverride buildable = new RouteListenerBootstrapOverride();
            buildable.setAddress(fluent.getAddress());
            buildable.setHost(fluent.getHost());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RouteListenerBootstrapOverrideBuilder that = (RouteListenerBootstrapOverrideBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
