package io.strimzi.api.kafka.model.listener;

import java.lang.Object;
import java.lang.Boolean;

public class NodePortListenerConfigurationFluentImpl<A extends NodePortListenerConfigurationFluent<A>> extends KafkaListenerExternalConfigurationFluentImpl<A> implements NodePortListenerConfigurationFluent<A>{

    private NodeAddressType preferredAddressType;

    public NodePortListenerConfigurationFluentImpl(){
    }
    public NodePortListenerConfigurationFluentImpl(NodePortListenerConfiguration instance){
            this.withPreferredAddressType(instance.getPreferredAddressType());

            this.withBrokerCertChainAndKey(instance.getBrokerCertChainAndKey());

    }

    public NodeAddressType getPreferredAddressType(){
            return this.preferredAddressType;
    }

    public A withPreferredAddressType(NodeAddressType preferredAddressType){
            this.preferredAddressType=preferredAddressType; return (A) this;
    }

    public Boolean hasPreferredAddressType(){
            return this.preferredAddressType != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            NodePortListenerConfigurationFluentImpl that = (NodePortListenerConfigurationFluentImpl) o;
            if (preferredAddressType != null ? !preferredAddressType.equals(that.preferredAddressType) :that.preferredAddressType != null) return false;
            return true;
    }




}
