package io.strimzi.api.kafka.model.listener;

import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;

public class NodePortListenerBootstrapOverrideFluentImpl<A extends NodePortListenerBootstrapOverrideFluent<A>> extends ExternalListenerBootstrapOverrideFluentImpl<A> implements NodePortListenerBootstrapOverrideFluent<A>{

    private Integer nodePort;
    private Map<String,String> dnsAnnotations;

    public NodePortListenerBootstrapOverrideFluentImpl(){
    }
    public NodePortListenerBootstrapOverrideFluentImpl(NodePortListenerBootstrapOverride instance){
            this.withNodePort(instance.getNodePort());

            this.withDnsAnnotations(instance.getDnsAnnotations());

            this.withAddress(instance.getAddress());

    }

    public Integer getNodePort(){
            return this.nodePort;
    }

    public A withNodePort(Integer nodePort){
            this.nodePort=nodePort; return (A) this;
    }

    public Boolean hasNodePort(){
            return this.nodePort != null;
    }

    public A addToDnsAnnotations(String key,String value){
            if(this.dnsAnnotations == null && key != null && value != null) { this.dnsAnnotations = new LinkedHashMap<String,String>(); }
            if(key != null && value != null) {this.dnsAnnotations.put(key, value);} return (A)this;
    }

    public A addToDnsAnnotations(Map<String,String> map){
            if(this.dnsAnnotations == null && map != null) { this.dnsAnnotations = new LinkedHashMap<String,String>(); }
            if(map != null) { this.dnsAnnotations.putAll(map);} return (A)this;
    }

    public A removeFromDnsAnnotations(String key){
            if(this.dnsAnnotations == null) { return (A) this; }
            if(key != null && this.dnsAnnotations != null) {this.dnsAnnotations.remove(key);} return (A)this;
    }

    public A removeFromDnsAnnotations(Map<String,String> map){
            if(this.dnsAnnotations == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.dnsAnnotations != null){this.dnsAnnotations.remove(key);}}} return (A)this;
    }

    public Map<String,String> getDnsAnnotations(){
            return this.dnsAnnotations;
    }

    public A withDnsAnnotations(Map<String,String> dnsAnnotations){
            if (dnsAnnotations == null) { this.dnsAnnotations =  null;} else {this.dnsAnnotations = new LinkedHashMap<String,String>(dnsAnnotations);} return (A) this;
    }

    public Boolean hasDnsAnnotations(){
            return this.dnsAnnotations != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            NodePortListenerBootstrapOverrideFluentImpl that = (NodePortListenerBootstrapOverrideFluentImpl) o;
            if (nodePort != null ? !nodePort.equals(that.nodePort) :that.nodePort != null) return false;
            if (dnsAnnotations != null ? !dnsAnnotations.equals(that.dnsAnnotations) :that.dnsAnnotations != null) return false;
            return true;
    }




}
