package io.strimzi.api.kafka.model.listener;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class LoadBalancerListenerBootstrapOverrideBuilder extends LoadBalancerListenerBootstrapOverrideFluentImpl<LoadBalancerListenerBootstrapOverrideBuilder> implements VisitableBuilder<LoadBalancerListenerBootstrapOverride,LoadBalancerListenerBootstrapOverrideBuilder>{

    LoadBalancerListenerBootstrapOverrideFluent<?> fluent;
    Boolean validationEnabled;

    public LoadBalancerListenerBootstrapOverrideBuilder(){
            this(true);
    }
    public LoadBalancerListenerBootstrapOverrideBuilder(Boolean validationEnabled){
            this(new LoadBalancerListenerBootstrapOverride(), validationEnabled);
    }
    public LoadBalancerListenerBootstrapOverrideBuilder(LoadBalancerListenerBootstrapOverrideFluent<?> fluent){
            this(fluent, true);
    }
    public LoadBalancerListenerBootstrapOverrideBuilder(LoadBalancerListenerBootstrapOverrideFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new LoadBalancerListenerBootstrapOverride(), validationEnabled);
    }
    public LoadBalancerListenerBootstrapOverrideBuilder(LoadBalancerListenerBootstrapOverrideFluent<?> fluent,LoadBalancerListenerBootstrapOverride instance){
            this(fluent, instance, true);
    }
    public LoadBalancerListenerBootstrapOverrideBuilder(LoadBalancerListenerBootstrapOverrideFluent<?> fluent,LoadBalancerListenerBootstrapOverride instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withDnsAnnotations(instance.getDnsAnnotations());

            fluent.withLoadBalancerIP(instance.getLoadBalancerIP());

            fluent.withAddress(instance.getAddress());

            this.validationEnabled = validationEnabled; 
    }
    public LoadBalancerListenerBootstrapOverrideBuilder(LoadBalancerListenerBootstrapOverride instance){
            this(instance,true);
    }
    public LoadBalancerListenerBootstrapOverrideBuilder(LoadBalancerListenerBootstrapOverride instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withDnsAnnotations(instance.getDnsAnnotations());

            this.withLoadBalancerIP(instance.getLoadBalancerIP());

            this.withAddress(instance.getAddress());

            this.validationEnabled = validationEnabled; 
    }

    public LoadBalancerListenerBootstrapOverride build(){
            LoadBalancerListenerBootstrapOverride buildable = new LoadBalancerListenerBootstrapOverride();
            buildable.setAddress(fluent.getAddress());
            buildable.setDnsAnnotations(fluent.getDnsAnnotations());
            buildable.setLoadBalancerIP(fluent.getLoadBalancerIP());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            LoadBalancerListenerBootstrapOverrideBuilder that = (LoadBalancerListenerBootstrapOverrideBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
