package io.strimzi.api.kafka.model.listener;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;

public class KafkaListenersFluentImpl<A extends KafkaListenersFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements KafkaListenersFluent<A>{

    private KafkaListenerTlsBuilder tls;
    private KafkaListenerPlainBuilder plain;
    private VisitableBuilder<? extends KafkaListenerExternal,?> external;

    public KafkaListenersFluentImpl(){
    }
    public KafkaListenersFluentImpl(KafkaListeners instance){
            this.withTls(instance.getTls());

            this.withPlain(instance.getPlain());

            this.withExternal(instance.getExternal());

    }

    
/**
 * This method has been deprecated, please use method buildTls instead.
 * @return The buildable object.
 */
@Deprecated public KafkaListenerTls getTls(){
            return this.tls!=null?this.tls.build():null;
    }

    public KafkaListenerTls buildTls(){
            return this.tls!=null?this.tls.build():null;
    }

    public A withTls(KafkaListenerTls tls){
            _visitables.get("tls").remove(this.tls);
            if (tls!=null){ this.tls= new KafkaListenerTlsBuilder(tls); _visitables.get("tls").add(this.tls);} return (A) this;
    }

    public Boolean hasTls(){
            return this.tls != null;
    }

    public KafkaListenersFluent.TlsNested<A> withNewTls(){
            return new TlsNestedImpl();
    }

    public KafkaListenersFluent.TlsNested<A> withNewTlsLike(KafkaListenerTls item){
            return new TlsNestedImpl(item);
    }

    public KafkaListenersFluent.TlsNested<A> editTls(){
            return withNewTlsLike(getTls());
    }

    public KafkaListenersFluent.TlsNested<A> editOrNewTls(){
            return withNewTlsLike(getTls() != null ? getTls(): new KafkaListenerTlsBuilder().build());
    }

    public KafkaListenersFluent.TlsNested<A> editOrNewTlsLike(KafkaListenerTls item){
            return withNewTlsLike(getTls() != null ? getTls(): item);
    }

    
/**
 * This method has been deprecated, please use method buildPlain instead.
 * @return The buildable object.
 */
@Deprecated public KafkaListenerPlain getPlain(){
            return this.plain!=null?this.plain.build():null;
    }

    public KafkaListenerPlain buildPlain(){
            return this.plain!=null?this.plain.build():null;
    }

    public A withPlain(KafkaListenerPlain plain){
            _visitables.get("plain").remove(this.plain);
            if (plain!=null){ this.plain= new KafkaListenerPlainBuilder(plain); _visitables.get("plain").add(this.plain);} return (A) this;
    }

    public Boolean hasPlain(){
            return this.plain != null;
    }

    public KafkaListenersFluent.PlainNested<A> withNewPlain(){
            return new PlainNestedImpl();
    }

    public KafkaListenersFluent.PlainNested<A> withNewPlainLike(KafkaListenerPlain item){
            return new PlainNestedImpl(item);
    }

    public KafkaListenersFluent.PlainNested<A> editPlain(){
            return withNewPlainLike(getPlain());
    }

    public KafkaListenersFluent.PlainNested<A> editOrNewPlain(){
            return withNewPlainLike(getPlain() != null ? getPlain(): new KafkaListenerPlainBuilder().build());
    }

    public KafkaListenersFluent.PlainNested<A> editOrNewPlainLike(KafkaListenerPlain item){
            return withNewPlainLike(getPlain() != null ? getPlain(): item);
    }

    
/**
 * This method has been deprecated, please use method buildExternal instead.
 * @return The buildable object.
 */
@Deprecated public KafkaListenerExternal getExternal(){
            return this.external!=null?this.external.build():null;
    }

    public KafkaListenerExternal buildExternal(){
            return this.external!=null?this.external.build():null;
    }

    public A withExternal(KafkaListenerExternal external){
            if (external instanceof KafkaListenerExternalRoute){ this.external= new KafkaListenerExternalRouteBuilder((KafkaListenerExternalRoute)external); _visitables.get("external").add(this.external);}
            if (external instanceof KafkaListenerExternalNodePort){ this.external= new KafkaListenerExternalNodePortBuilder((KafkaListenerExternalNodePort)external); _visitables.get("external").add(this.external);}
            if (external instanceof KafkaListenerExternalIngress){ this.external= new KafkaListenerExternalIngressBuilder((KafkaListenerExternalIngress)external); _visitables.get("external").add(this.external);}
            if (external instanceof KafkaListenerExternalLoadBalancer){ this.external= new KafkaListenerExternalLoadBalancerBuilder((KafkaListenerExternalLoadBalancer)external); _visitables.get("external").add(this.external);}
            return (A) this;
    }

    public Boolean hasExternal(){
            return this.external != null;
    }

    public A withKafkaListenerExternalRoute(KafkaListenerExternalRoute kafkaListenerExternalRoute){
            _visitables.get("external").remove(this.external);
            if (kafkaListenerExternalRoute!=null){ this.external= new KafkaListenerExternalRouteBuilder(kafkaListenerExternalRoute); _visitables.get("external").add(this.external);} return (A) this;
    }

    public KafkaListenersFluent.KafkaListenerExternalRouteNested<A> withNewKafkaListenerExternalRoute(){
            return new KafkaListenerExternalRouteNestedImpl();
    }

    public KafkaListenersFluent.KafkaListenerExternalRouteNested<A> withNewKafkaListenerExternalRouteLike(KafkaListenerExternalRoute item){
            return new KafkaListenerExternalRouteNestedImpl(item);
    }

    public A withKafkaListenerExternalNodePort(KafkaListenerExternalNodePort kafkaListenerExternalNodePort){
            _visitables.get("external").remove(this.external);
            if (kafkaListenerExternalNodePort!=null){ this.external= new KafkaListenerExternalNodePortBuilder(kafkaListenerExternalNodePort); _visitables.get("external").add(this.external);} return (A) this;
    }

    public KafkaListenersFluent.KafkaListenerExternalNodePortNested<A> withNewKafkaListenerExternalNodePort(){
            return new KafkaListenerExternalNodePortNestedImpl();
    }

    public KafkaListenersFluent.KafkaListenerExternalNodePortNested<A> withNewKafkaListenerExternalNodePortLike(KafkaListenerExternalNodePort item){
            return new KafkaListenerExternalNodePortNestedImpl(item);
    }

    public A withKafkaListenerExternalIngress(KafkaListenerExternalIngress kafkaListenerExternalIngress){
            _visitables.get("external").remove(this.external);
            if (kafkaListenerExternalIngress!=null){ this.external= new KafkaListenerExternalIngressBuilder(kafkaListenerExternalIngress); _visitables.get("external").add(this.external);} return (A) this;
    }

    public KafkaListenersFluent.KafkaListenerExternalIngressNested<A> withNewKafkaListenerExternalIngress(){
            return new KafkaListenerExternalIngressNestedImpl();
    }

    public KafkaListenersFluent.KafkaListenerExternalIngressNested<A> withNewKafkaListenerExternalIngressLike(KafkaListenerExternalIngress item){
            return new KafkaListenerExternalIngressNestedImpl(item);
    }

    public A withKafkaListenerExternalLoadBalancer(KafkaListenerExternalLoadBalancer kafkaListenerExternalLoadBalancer){
            _visitables.get("external").remove(this.external);
            if (kafkaListenerExternalLoadBalancer!=null){ this.external= new KafkaListenerExternalLoadBalancerBuilder(kafkaListenerExternalLoadBalancer); _visitables.get("external").add(this.external);} return (A) this;
    }

    public KafkaListenersFluent.KafkaListenerExternalLoadBalancerNested<A> withNewKafkaListenerExternalLoadBalancer(){
            return new KafkaListenerExternalLoadBalancerNestedImpl();
    }

    public KafkaListenersFluent.KafkaListenerExternalLoadBalancerNested<A> withNewKafkaListenerExternalLoadBalancerLike(KafkaListenerExternalLoadBalancer item){
            return new KafkaListenerExternalLoadBalancerNestedImpl(item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            KafkaListenersFluentImpl that = (KafkaListenersFluentImpl) o;
            if (tls != null ? !tls.equals(that.tls) :that.tls != null) return false;
            if (plain != null ? !plain.equals(that.plain) :that.plain != null) return false;
            if (external != null ? !external.equals(that.external) :that.external != null) return false;
            return true;
    }


    public class TlsNestedImpl<N> extends KafkaListenerTlsFluentImpl<KafkaListenersFluent.TlsNested<N>> implements KafkaListenersFluent.TlsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final KafkaListenerTlsBuilder builder;
    
            TlsNestedImpl(KafkaListenerTls item){
                    this.builder = new KafkaListenerTlsBuilder(this, item);
            }
            TlsNestedImpl(){
                    this.builder = new KafkaListenerTlsBuilder(this);
            }
    
    public N and(){
            return (N) KafkaListenersFluentImpl.this.withTls(builder.build());
    }
    public N endTls(){
            return and();
    }

}
    public class PlainNestedImpl<N> extends KafkaListenerPlainFluentImpl<KafkaListenersFluent.PlainNested<N>> implements KafkaListenersFluent.PlainNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final KafkaListenerPlainBuilder builder;
    
            PlainNestedImpl(KafkaListenerPlain item){
                    this.builder = new KafkaListenerPlainBuilder(this, item);
            }
            PlainNestedImpl(){
                    this.builder = new KafkaListenerPlainBuilder(this);
            }
    
    public N and(){
            return (N) KafkaListenersFluentImpl.this.withPlain(builder.build());
    }
    public N endPlain(){
            return and();
    }

}
    public class KafkaListenerExternalRouteNestedImpl<N> extends KafkaListenerExternalRouteFluentImpl<KafkaListenersFluent.KafkaListenerExternalRouteNested<N>> implements KafkaListenersFluent.KafkaListenerExternalRouteNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final KafkaListenerExternalRouteBuilder builder;
    
            KafkaListenerExternalRouteNestedImpl(KafkaListenerExternalRoute item){
                    this.builder = new KafkaListenerExternalRouteBuilder(this, item);
            }
            KafkaListenerExternalRouteNestedImpl(){
                    this.builder = new KafkaListenerExternalRouteBuilder(this);
            }
    
    public N and(){
            return (N) KafkaListenersFluentImpl.this.withKafkaListenerExternalRoute(builder.build());
    }
    public N endKafkaListenerExternalRoute(){
            return and();
    }

}
    public class KafkaListenerExternalNodePortNestedImpl<N> extends KafkaListenerExternalNodePortFluentImpl<KafkaListenersFluent.KafkaListenerExternalNodePortNested<N>> implements KafkaListenersFluent.KafkaListenerExternalNodePortNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final KafkaListenerExternalNodePortBuilder builder;
    
            KafkaListenerExternalNodePortNestedImpl(KafkaListenerExternalNodePort item){
                    this.builder = new KafkaListenerExternalNodePortBuilder(this, item);
            }
            KafkaListenerExternalNodePortNestedImpl(){
                    this.builder = new KafkaListenerExternalNodePortBuilder(this);
            }
    
    public N and(){
            return (N) KafkaListenersFluentImpl.this.withKafkaListenerExternalNodePort(builder.build());
    }
    public N endKafkaListenerExternalNodePort(){
            return and();
    }

}
    public class KafkaListenerExternalIngressNestedImpl<N> extends KafkaListenerExternalIngressFluentImpl<KafkaListenersFluent.KafkaListenerExternalIngressNested<N>> implements KafkaListenersFluent.KafkaListenerExternalIngressNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final KafkaListenerExternalIngressBuilder builder;
    
            KafkaListenerExternalIngressNestedImpl(KafkaListenerExternalIngress item){
                    this.builder = new KafkaListenerExternalIngressBuilder(this, item);
            }
            KafkaListenerExternalIngressNestedImpl(){
                    this.builder = new KafkaListenerExternalIngressBuilder(this);
            }
    
    public N and(){
            return (N) KafkaListenersFluentImpl.this.withKafkaListenerExternalIngress(builder.build());
    }
    public N endKafkaListenerExternalIngress(){
            return and();
    }

}
    public class KafkaListenerExternalLoadBalancerNestedImpl<N> extends KafkaListenerExternalLoadBalancerFluentImpl<KafkaListenersFluent.KafkaListenerExternalLoadBalancerNested<N>> implements KafkaListenersFluent.KafkaListenerExternalLoadBalancerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final KafkaListenerExternalLoadBalancerBuilder builder;
    
            KafkaListenerExternalLoadBalancerNestedImpl(KafkaListenerExternalLoadBalancer item){
                    this.builder = new KafkaListenerExternalLoadBalancerBuilder(this, item);
            }
            KafkaListenerExternalLoadBalancerNestedImpl(){
                    this.builder = new KafkaListenerExternalLoadBalancerBuilder(this);
            }
    
    public N and(){
            return (N) KafkaListenersFluentImpl.this.withKafkaListenerExternalLoadBalancer(builder.build());
    }
    public N endKafkaListenerExternalLoadBalancer(){
            return and();
    }

}


}
