package io.strimzi.api.kafka.model.listener;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaListenerPlainBuilder extends KafkaListenerPlainFluentImpl<KafkaListenerPlainBuilder> implements VisitableBuilder<KafkaListenerPlain,KafkaListenerPlainBuilder>{

    KafkaListenerPlainFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaListenerPlainBuilder(){
            this(true);
    }
    public KafkaListenerPlainBuilder(Boolean validationEnabled){
            this(new KafkaListenerPlain(), validationEnabled);
    }
    public KafkaListenerPlainBuilder(KafkaListenerPlainFluent<?> fluent){
            this(fluent, true);
    }
    public KafkaListenerPlainBuilder(KafkaListenerPlainFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new KafkaListenerPlain(), validationEnabled);
    }
    public KafkaListenerPlainBuilder(KafkaListenerPlainFluent<?> fluent,KafkaListenerPlain instance){
            this(fluent, instance, true);
    }
    public KafkaListenerPlainBuilder(KafkaListenerPlainFluent<?> fluent,KafkaListenerPlain instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAuth(instance.getAuth());

            fluent.withNetworkPolicyPeers(instance.getNetworkPolicyPeers());

            this.validationEnabled = validationEnabled; 
    }
    public KafkaListenerPlainBuilder(KafkaListenerPlain instance){
            this(instance,true);
    }
    public KafkaListenerPlainBuilder(KafkaListenerPlain instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAuth(instance.getAuth());

            this.withNetworkPolicyPeers(instance.getNetworkPolicyPeers());

            this.validationEnabled = validationEnabled; 
    }

    public KafkaListenerPlain build(){
            KafkaListenerPlain buildable = new KafkaListenerPlain();
            buildable.setAuth(fluent.getAuth());
            buildable.setNetworkPolicyPeers(fluent.getNetworkPolicyPeers());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KafkaListenerPlainBuilder that = (KafkaListenerPlainBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
