package io.strimzi.api.kafka.model.listener;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaListenerExternalNodePortBuilder extends KafkaListenerExternalNodePortFluentImpl<KafkaListenerExternalNodePortBuilder> implements VisitableBuilder<KafkaListenerExternalNodePort,KafkaListenerExternalNodePortBuilder>{

    KafkaListenerExternalNodePortFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaListenerExternalNodePortBuilder(){
            this(true);
    }
    public KafkaListenerExternalNodePortBuilder(Boolean validationEnabled){
            this(new KafkaListenerExternalNodePort(), validationEnabled);
    }
    public KafkaListenerExternalNodePortBuilder(KafkaListenerExternalNodePortFluent<?> fluent){
            this(fluent, true);
    }
    public KafkaListenerExternalNodePortBuilder(KafkaListenerExternalNodePortFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new KafkaListenerExternalNodePort(), validationEnabled);
    }
    public KafkaListenerExternalNodePortBuilder(KafkaListenerExternalNodePortFluent<?> fluent,KafkaListenerExternalNodePort instance){
            this(fluent, instance, true);
    }
    public KafkaListenerExternalNodePortBuilder(KafkaListenerExternalNodePortFluent<?> fluent,KafkaListenerExternalNodePort instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAuth(instance.getAuth());

            fluent.withTls(instance.isTls());

            fluent.withNetworkPolicyPeers(instance.getNetworkPolicyPeers());

            fluent.withOverrides(instance.getOverrides());

            fluent.withConfiguration(instance.getConfiguration());

            this.validationEnabled = validationEnabled; 
    }
    public KafkaListenerExternalNodePortBuilder(KafkaListenerExternalNodePort instance){
            this(instance,true);
    }
    public KafkaListenerExternalNodePortBuilder(KafkaListenerExternalNodePort instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAuth(instance.getAuth());

            this.withTls(instance.isTls());

            this.withNetworkPolicyPeers(instance.getNetworkPolicyPeers());

            this.withOverrides(instance.getOverrides());

            this.withConfiguration(instance.getConfiguration());

            this.validationEnabled = validationEnabled; 
    }

    public KafkaListenerExternalNodePort build(){
            KafkaListenerExternalNodePort buildable = new KafkaListenerExternalNodePort();
            buildable.setAuth(fluent.getAuth());
            buildable.setTls(fluent.isTls());
            buildable.setNetworkPolicyPeers(fluent.getNetworkPolicyPeers());
            buildable.setOverrides(fluent.getOverrides());
            buildable.setConfiguration(fluent.getConfiguration());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KafkaListenerExternalNodePortBuilder that = (KafkaListenerExternalNodePortBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
