package io.strimzi.api.kafka.model.listener;

import io.strimzi.api.kafka.model.GenericSecretSource;
import io.strimzi.api.kafka.model.GenericSecretSourceBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.CertSecretSourceFluentImpl;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.GenericSecretSourceFluentImpl;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.StringBuffer;
import io.strimzi.api.kafka.model.CertSecretSourceBuilder;
import java.util.Collection;
import java.lang.Object;
import io.strimzi.api.kafka.model.CertSecretSource;

public class KafkaListenerAuthenticationOAuthFluentImpl<A extends KafkaListenerAuthenticationOAuthFluent<A>> extends KafkaListenerAuthenticationFluentImpl<A> implements KafkaListenerAuthenticationOAuthFluent<A>{

    private String clientId;
    private GenericSecretSourceBuilder clientSecret;
    private String validIssuerUri;
    private String jwksEndpointUri;
    private int jwksRefreshSeconds;
    private int jwksExpirySeconds;
    private String introspectionEndpointUri;
    private String userNameClaim;
    private boolean checkAccessTokenType;
    private boolean accessTokenIsJwt;
    private List<CertSecretSourceBuilder> tlsTrustedCertificates;
    private boolean disableTlsHostnameVerification;

    public KafkaListenerAuthenticationOAuthFluentImpl(){
    }
    public KafkaListenerAuthenticationOAuthFluentImpl(KafkaListenerAuthenticationOAuth instance){
            this.withClientId(instance.getClientId());

            this.withClientSecret(instance.getClientSecret());

            this.withValidIssuerUri(instance.getValidIssuerUri());

            this.withJwksEndpointUri(instance.getJwksEndpointUri());

            this.withJwksRefreshSeconds(instance.getJwksRefreshSeconds());

            this.withJwksExpirySeconds(instance.getJwksExpirySeconds());

            this.withIntrospectionEndpointUri(instance.getIntrospectionEndpointUri());

            this.withUserNameClaim(instance.getUserNameClaim());

            this.withCheckAccessTokenType(instance.isCheckAccessTokenType());

            this.withAccessTokenIsJwt(instance.isAccessTokenIsJwt());

            this.withTlsTrustedCertificates(instance.getTlsTrustedCertificates());

            this.withDisableTlsHostnameVerification(instance.isDisableTlsHostnameVerification());

    }

    public String getClientId(){
            return this.clientId;
    }

    public A withClientId(String clientId){
            this.clientId=clientId; return (A) this;
    }

    public Boolean hasClientId(){
            return this.clientId != null;
    }

    public A withNewClientId(String arg1){
            return (A)withClientId(new String(arg1));
    }

    public A withNewClientId(StringBuilder arg1){
            return (A)withClientId(new String(arg1));
    }

    public A withNewClientId(StringBuffer arg1){
            return (A)withClientId(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildClientSecret instead.
 * @return The buildable object.
 */
@Deprecated public GenericSecretSource getClientSecret(){
            return this.clientSecret!=null?this.clientSecret.build():null;
    }

    public GenericSecretSource buildClientSecret(){
            return this.clientSecret!=null?this.clientSecret.build():null;
    }

    public A withClientSecret(GenericSecretSource clientSecret){
            _visitables.get("clientSecret").remove(this.clientSecret);
            if (clientSecret!=null){ this.clientSecret= new GenericSecretSourceBuilder(clientSecret); _visitables.get("clientSecret").add(this.clientSecret);} return (A) this;
    }

    public Boolean hasClientSecret(){
            return this.clientSecret != null;
    }

    public KafkaListenerAuthenticationOAuthFluent.ClientSecretNested<A> withNewClientSecret(){
            return new ClientSecretNestedImpl();
    }

    public KafkaListenerAuthenticationOAuthFluent.ClientSecretNested<A> withNewClientSecretLike(GenericSecretSource item){
            return new ClientSecretNestedImpl(item);
    }

    public KafkaListenerAuthenticationOAuthFluent.ClientSecretNested<A> editClientSecret(){
            return withNewClientSecretLike(getClientSecret());
    }

    public KafkaListenerAuthenticationOAuthFluent.ClientSecretNested<A> editOrNewClientSecret(){
            return withNewClientSecretLike(getClientSecret() != null ? getClientSecret(): new GenericSecretSourceBuilder().build());
    }

    public KafkaListenerAuthenticationOAuthFluent.ClientSecretNested<A> editOrNewClientSecretLike(GenericSecretSource item){
            return withNewClientSecretLike(getClientSecret() != null ? getClientSecret(): item);
    }

    public String getValidIssuerUri(){
            return this.validIssuerUri;
    }

    public A withValidIssuerUri(String validIssuerUri){
            this.validIssuerUri=validIssuerUri; return (A) this;
    }

    public Boolean hasValidIssuerUri(){
            return this.validIssuerUri != null;
    }

    public A withNewValidIssuerUri(String arg1){
            return (A)withValidIssuerUri(new String(arg1));
    }

    public A withNewValidIssuerUri(StringBuilder arg1){
            return (A)withValidIssuerUri(new String(arg1));
    }

    public A withNewValidIssuerUri(StringBuffer arg1){
            return (A)withValidIssuerUri(new String(arg1));
    }

    public String getJwksEndpointUri(){
            return this.jwksEndpointUri;
    }

    public A withJwksEndpointUri(String jwksEndpointUri){
            this.jwksEndpointUri=jwksEndpointUri; return (A) this;
    }

    public Boolean hasJwksEndpointUri(){
            return this.jwksEndpointUri != null;
    }

    public A withNewJwksEndpointUri(String arg1){
            return (A)withJwksEndpointUri(new String(arg1));
    }

    public A withNewJwksEndpointUri(StringBuilder arg1){
            return (A)withJwksEndpointUri(new String(arg1));
    }

    public A withNewJwksEndpointUri(StringBuffer arg1){
            return (A)withJwksEndpointUri(new String(arg1));
    }

    public int getJwksRefreshSeconds(){
            return this.jwksRefreshSeconds;
    }

    public A withJwksRefreshSeconds(int jwksRefreshSeconds){
            this.jwksRefreshSeconds=jwksRefreshSeconds; return (A) this;
    }

    public Boolean hasJwksRefreshSeconds(){
            return true;
    }

    public int getJwksExpirySeconds(){
            return this.jwksExpirySeconds;
    }

    public A withJwksExpirySeconds(int jwksExpirySeconds){
            this.jwksExpirySeconds=jwksExpirySeconds; return (A) this;
    }

    public Boolean hasJwksExpirySeconds(){
            return true;
    }

    public String getIntrospectionEndpointUri(){
            return this.introspectionEndpointUri;
    }

    public A withIntrospectionEndpointUri(String introspectionEndpointUri){
            this.introspectionEndpointUri=introspectionEndpointUri; return (A) this;
    }

    public Boolean hasIntrospectionEndpointUri(){
            return this.introspectionEndpointUri != null;
    }

    public A withNewIntrospectionEndpointUri(String arg1){
            return (A)withIntrospectionEndpointUri(new String(arg1));
    }

    public A withNewIntrospectionEndpointUri(StringBuilder arg1){
            return (A)withIntrospectionEndpointUri(new String(arg1));
    }

    public A withNewIntrospectionEndpointUri(StringBuffer arg1){
            return (A)withIntrospectionEndpointUri(new String(arg1));
    }

    public String getUserNameClaim(){
            return this.userNameClaim;
    }

    public A withUserNameClaim(String userNameClaim){
            this.userNameClaim=userNameClaim; return (A) this;
    }

    public Boolean hasUserNameClaim(){
            return this.userNameClaim != null;
    }

    public A withNewUserNameClaim(String arg1){
            return (A)withUserNameClaim(new String(arg1));
    }

    public A withNewUserNameClaim(StringBuilder arg1){
            return (A)withUserNameClaim(new String(arg1));
    }

    public A withNewUserNameClaim(StringBuffer arg1){
            return (A)withUserNameClaim(new String(arg1));
    }

    public boolean isCheckAccessTokenType(){
            return this.checkAccessTokenType;
    }

    public A withCheckAccessTokenType(boolean checkAccessTokenType){
            this.checkAccessTokenType=checkAccessTokenType; return (A) this;
    }

    public Boolean hasCheckAccessTokenType(){
            return true;
    }

    public boolean isAccessTokenIsJwt(){
            return this.accessTokenIsJwt;
    }

    public A withAccessTokenIsJwt(boolean accessTokenIsJwt){
            this.accessTokenIsJwt=accessTokenIsJwt; return (A) this;
    }

    public Boolean hasAccessTokenIsJwt(){
            return true;
    }

    public A addToTlsTrustedCertificates(int index,CertSecretSource item){
            if (this.tlsTrustedCertificates == null) {this.tlsTrustedCertificates = new ArrayList<CertSecretSourceBuilder>();}
            CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);_visitables.get("tlsTrustedCertificates").add(index >= 0 ? index : _visitables.get("tlsTrustedCertificates").size(), builder);this.tlsTrustedCertificates.add(index >= 0 ? index : tlsTrustedCertificates.size(), builder); return (A)this;
    }

    public A setToTlsTrustedCertificates(int index,CertSecretSource item){
            if (this.tlsTrustedCertificates == null) {this.tlsTrustedCertificates = new ArrayList<CertSecretSourceBuilder>();}
            CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
            if (index < 0 || index >= _visitables.get("tlsTrustedCertificates").size()) { _visitables.get("tlsTrustedCertificates").add(builder); } else { _visitables.get("tlsTrustedCertificates").set(index, builder);}
            if (index < 0 || index >= tlsTrustedCertificates.size()) { tlsTrustedCertificates.add(builder); } else { tlsTrustedCertificates.set(index, builder);}
             return (A)this;
    }

    public A addToTlsTrustedCertificates(CertSecretSource... items){
            if (this.tlsTrustedCertificates == null) {this.tlsTrustedCertificates = new ArrayList<CertSecretSourceBuilder>();}
            for (CertSecretSource item : items) {CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);_visitables.get("tlsTrustedCertificates").add(builder);this.tlsTrustedCertificates.add(builder);} return (A)this;
    }

    public A addAllToTlsTrustedCertificates(Collection<CertSecretSource> items){
            if (this.tlsTrustedCertificates == null) {this.tlsTrustedCertificates = new ArrayList<CertSecretSourceBuilder>();}
            for (CertSecretSource item : items) {CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);_visitables.get("tlsTrustedCertificates").add(builder);this.tlsTrustedCertificates.add(builder);} return (A)this;
    }

    public A removeFromTlsTrustedCertificates(CertSecretSource... items){
            for (CertSecretSource item : items) {CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);_visitables.get("tlsTrustedCertificates").remove(builder);if (this.tlsTrustedCertificates != null) {this.tlsTrustedCertificates.remove(builder);}} return (A)this;
    }

    public A removeAllFromTlsTrustedCertificates(Collection<CertSecretSource> items){
            for (CertSecretSource item : items) {CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);_visitables.get("tlsTrustedCertificates").remove(builder);if (this.tlsTrustedCertificates != null) {this.tlsTrustedCertificates.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromTlsTrustedCertificates(io.fabric8.kubernetes.api.builder.Predicate<CertSecretSourceBuilder> predicate){
            if (tlsTrustedCertificates == null) return (A) this;
            final Iterator<CertSecretSourceBuilder> each = tlsTrustedCertificates.iterator();
            final List visitables = _visitables.get("tlsTrustedCertificates");
            while (each.hasNext()) {
              CertSecretSourceBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildTlsTrustedCertificates instead.
 * @return The buildable object.
 */
@Deprecated public List<CertSecretSource> getTlsTrustedCertificates(){
            return build(tlsTrustedCertificates);
    }

    public List<CertSecretSource> buildTlsTrustedCertificates(){
            return build(tlsTrustedCertificates);
    }

    public CertSecretSource buildTlsTrustedCertificate(int index){
            return this.tlsTrustedCertificates.get(index).build();
    }

    public CertSecretSource buildFirstTlsTrustedCertificate(){
            return this.tlsTrustedCertificates.get(0).build();
    }

    public CertSecretSource buildLastTlsTrustedCertificate(){
            return this.tlsTrustedCertificates.get(tlsTrustedCertificates.size() - 1).build();
    }

    public CertSecretSource buildMatchingTlsTrustedCertificate(io.fabric8.kubernetes.api.builder.Predicate<CertSecretSourceBuilder> predicate){
            for (CertSecretSourceBuilder item: tlsTrustedCertificates) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingTlsTrustedCertificate(io.fabric8.kubernetes.api.builder.Predicate<CertSecretSourceBuilder> predicate){
            for (CertSecretSourceBuilder item: tlsTrustedCertificates) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withTlsTrustedCertificates(List<CertSecretSource> tlsTrustedCertificates){
            if (this.tlsTrustedCertificates != null) { _visitables.get("tlsTrustedCertificates").removeAll(this.tlsTrustedCertificates);}
            if (tlsTrustedCertificates != null) {this.tlsTrustedCertificates = new ArrayList<CertSecretSourceBuilder>(); for (CertSecretSource item : tlsTrustedCertificates){this.addToTlsTrustedCertificates(item);}} else { this.tlsTrustedCertificates = null;} return (A) this;
    }

    public A withTlsTrustedCertificates(CertSecretSource... tlsTrustedCertificates){
            if (this.tlsTrustedCertificates != null) {this.tlsTrustedCertificates.clear();}
            if (tlsTrustedCertificates != null) {for (CertSecretSource item :tlsTrustedCertificates){ this.addToTlsTrustedCertificates(item);}} return (A) this;
    }

    public Boolean hasTlsTrustedCertificates(){
            return tlsTrustedCertificates != null && !tlsTrustedCertificates.isEmpty();
    }

    public KafkaListenerAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> addNewTlsTrustedCertificate(){
            return new TlsTrustedCertificatesNestedImpl();
    }

    public KafkaListenerAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> addNewTlsTrustedCertificateLike(CertSecretSource item){
            return new TlsTrustedCertificatesNestedImpl(-1, item);
    }

    public KafkaListenerAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> setNewTlsTrustedCertificateLike(int index,CertSecretSource item){
            return new TlsTrustedCertificatesNestedImpl(index, item);
    }

    public KafkaListenerAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> editTlsTrustedCertificate(int index){
            if (tlsTrustedCertificates.size() <= index) throw new RuntimeException("Can't edit tlsTrustedCertificates. Index exceeds size.");
            return setNewTlsTrustedCertificateLike(index, buildTlsTrustedCertificate(index));
    }

    public KafkaListenerAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> editFirstTlsTrustedCertificate(){
            if (tlsTrustedCertificates.size() == 0) throw new RuntimeException("Can't edit first tlsTrustedCertificates. The list is empty.");
            return setNewTlsTrustedCertificateLike(0, buildTlsTrustedCertificate(0));
    }

    public KafkaListenerAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> editLastTlsTrustedCertificate(){
            int index = tlsTrustedCertificates.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last tlsTrustedCertificates. The list is empty.");
            return setNewTlsTrustedCertificateLike(index, buildTlsTrustedCertificate(index));
    }

    public KafkaListenerAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> editMatchingTlsTrustedCertificate(io.fabric8.kubernetes.api.builder.Predicate<CertSecretSourceBuilder> predicate){
            int index = -1;
            for (int i=0;i<tlsTrustedCertificates.size();i++) { 
            if (predicate.apply(tlsTrustedCertificates.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching tlsTrustedCertificates. No match found.");
            return setNewTlsTrustedCertificateLike(index, buildTlsTrustedCertificate(index));
    }

    public boolean isDisableTlsHostnameVerification(){
            return this.disableTlsHostnameVerification;
    }

    public A withDisableTlsHostnameVerification(boolean disableTlsHostnameVerification){
            this.disableTlsHostnameVerification=disableTlsHostnameVerification; return (A) this;
    }

    public Boolean hasDisableTlsHostnameVerification(){
            return true;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KafkaListenerAuthenticationOAuthFluentImpl that = (KafkaListenerAuthenticationOAuthFluentImpl) o;
            if (clientId != null ? !clientId.equals(that.clientId) :that.clientId != null) return false;
            if (clientSecret != null ? !clientSecret.equals(that.clientSecret) :that.clientSecret != null) return false;
            if (validIssuerUri != null ? !validIssuerUri.equals(that.validIssuerUri) :that.validIssuerUri != null) return false;
            if (jwksEndpointUri != null ? !jwksEndpointUri.equals(that.jwksEndpointUri) :that.jwksEndpointUri != null) return false;
            if (jwksRefreshSeconds != that.jwksRefreshSeconds) return false;
            if (jwksExpirySeconds != that.jwksExpirySeconds) return false;
            if (introspectionEndpointUri != null ? !introspectionEndpointUri.equals(that.introspectionEndpointUri) :that.introspectionEndpointUri != null) return false;
            if (userNameClaim != null ? !userNameClaim.equals(that.userNameClaim) :that.userNameClaim != null) return false;
            if (checkAccessTokenType != that.checkAccessTokenType) return false;
            if (accessTokenIsJwt != that.accessTokenIsJwt) return false;
            if (tlsTrustedCertificates != null ? !tlsTrustedCertificates.equals(that.tlsTrustedCertificates) :that.tlsTrustedCertificates != null) return false;
            if (disableTlsHostnameVerification != that.disableTlsHostnameVerification) return false;
            return true;
    }


    public class ClientSecretNestedImpl<N> extends GenericSecretSourceFluentImpl<KafkaListenerAuthenticationOAuthFluent.ClientSecretNested<N>> implements KafkaListenerAuthenticationOAuthFluent.ClientSecretNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final GenericSecretSourceBuilder builder;
    
            ClientSecretNestedImpl(GenericSecretSource item){
                    this.builder = new GenericSecretSourceBuilder(this, item);
            }
            ClientSecretNestedImpl(){
                    this.builder = new GenericSecretSourceBuilder(this);
            }
    
    public N and(){
            return (N) KafkaListenerAuthenticationOAuthFluentImpl.this.withClientSecret(builder.build());
    }
    public N endClientSecret(){
            return and();
    }

}
    public class TlsTrustedCertificatesNestedImpl<N> extends CertSecretSourceFluentImpl<KafkaListenerAuthenticationOAuthFluent.TlsTrustedCertificatesNested<N>> implements KafkaListenerAuthenticationOAuthFluent.TlsTrustedCertificatesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final CertSecretSourceBuilder builder;
        private final int index;
    
            TlsTrustedCertificatesNestedImpl(int index,CertSecretSource item){
                    this.index = index;
                    this.builder = new CertSecretSourceBuilder(this, item);
            }
            TlsTrustedCertificatesNestedImpl(){
                    this.index = -1;
                    this.builder = new CertSecretSourceBuilder(this);
            }
    
    public N and(){
            return (N) KafkaListenerAuthenticationOAuthFluentImpl.this.setToTlsTrustedCertificates(index, builder.build());
    }
    public N endTlsTrustedCertificate(){
            return and();
    }

}


}
