package io.strimzi.api.kafka.model.listener;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaListenerAuthenticationOAuthBuilder extends KafkaListenerAuthenticationOAuthFluentImpl<KafkaListenerAuthenticationOAuthBuilder> implements VisitableBuilder<KafkaListenerAuthenticationOAuth,KafkaListenerAuthenticationOAuthBuilder>{

    KafkaListenerAuthenticationOAuthFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaListenerAuthenticationOAuthBuilder(){
            this(true);
    }
    public KafkaListenerAuthenticationOAuthBuilder(Boolean validationEnabled){
            this(new KafkaListenerAuthenticationOAuth(), validationEnabled);
    }
    public KafkaListenerAuthenticationOAuthBuilder(KafkaListenerAuthenticationOAuthFluent<?> fluent){
            this(fluent, true);
    }
    public KafkaListenerAuthenticationOAuthBuilder(KafkaListenerAuthenticationOAuthFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new KafkaListenerAuthenticationOAuth(), validationEnabled);
    }
    public KafkaListenerAuthenticationOAuthBuilder(KafkaListenerAuthenticationOAuthFluent<?> fluent,KafkaListenerAuthenticationOAuth instance){
            this(fluent, instance, true);
    }
    public KafkaListenerAuthenticationOAuthBuilder(KafkaListenerAuthenticationOAuthFluent<?> fluent,KafkaListenerAuthenticationOAuth instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withClientId(instance.getClientId());

            fluent.withClientSecret(instance.getClientSecret());

            fluent.withValidIssuerUri(instance.getValidIssuerUri());

            fluent.withJwksEndpointUri(instance.getJwksEndpointUri());

            fluent.withJwksRefreshSeconds(instance.getJwksRefreshSeconds());

            fluent.withJwksExpirySeconds(instance.getJwksExpirySeconds());

            fluent.withIntrospectionEndpointUri(instance.getIntrospectionEndpointUri());

            fluent.withUserNameClaim(instance.getUserNameClaim());

            fluent.withCheckAccessTokenType(instance.isCheckAccessTokenType());

            fluent.withAccessTokenIsJwt(instance.isAccessTokenIsJwt());

            fluent.withTlsTrustedCertificates(instance.getTlsTrustedCertificates());

            fluent.withDisableTlsHostnameVerification(instance.isDisableTlsHostnameVerification());

            this.validationEnabled = validationEnabled; 
    }
    public KafkaListenerAuthenticationOAuthBuilder(KafkaListenerAuthenticationOAuth instance){
            this(instance,true);
    }
    public KafkaListenerAuthenticationOAuthBuilder(KafkaListenerAuthenticationOAuth instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withClientId(instance.getClientId());

            this.withClientSecret(instance.getClientSecret());

            this.withValidIssuerUri(instance.getValidIssuerUri());

            this.withJwksEndpointUri(instance.getJwksEndpointUri());

            this.withJwksRefreshSeconds(instance.getJwksRefreshSeconds());

            this.withJwksExpirySeconds(instance.getJwksExpirySeconds());

            this.withIntrospectionEndpointUri(instance.getIntrospectionEndpointUri());

            this.withUserNameClaim(instance.getUserNameClaim());

            this.withCheckAccessTokenType(instance.isCheckAccessTokenType());

            this.withAccessTokenIsJwt(instance.isAccessTokenIsJwt());

            this.withTlsTrustedCertificates(instance.getTlsTrustedCertificates());

            this.withDisableTlsHostnameVerification(instance.isDisableTlsHostnameVerification());

            this.validationEnabled = validationEnabled; 
    }

    public KafkaListenerAuthenticationOAuth build(){
            KafkaListenerAuthenticationOAuth buildable = new KafkaListenerAuthenticationOAuth();
            buildable.setClientId(fluent.getClientId());
            buildable.setClientSecret(fluent.getClientSecret());
            buildable.setValidIssuerUri(fluent.getValidIssuerUri());
            buildable.setJwksEndpointUri(fluent.getJwksEndpointUri());
            buildable.setJwksRefreshSeconds(fluent.getJwksRefreshSeconds());
            buildable.setJwksExpirySeconds(fluent.getJwksExpirySeconds());
            buildable.setIntrospectionEndpointUri(fluent.getIntrospectionEndpointUri());
            buildable.setUserNameClaim(fluent.getUserNameClaim());
            buildable.setCheckAccessTokenType(fluent.isCheckAccessTokenType());
            buildable.setAccessTokenIsJwt(fluent.isAccessTokenIsJwt());
            buildable.setTlsTrustedCertificates(fluent.getTlsTrustedCertificates());
            buildable.setDisableTlsHostnameVerification(fluent.isDisableTlsHostnameVerification());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KafkaListenerAuthenticationOAuthBuilder that = (KafkaListenerAuthenticationOAuthBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
