package io.strimzi.api.kafka.model.listener;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class IngressListenerBootstrapConfigurationBuilder extends IngressListenerBootstrapConfigurationFluentImpl<IngressListenerBootstrapConfigurationBuilder> implements VisitableBuilder<IngressListenerBootstrapConfiguration,IngressListenerBootstrapConfigurationBuilder>{

    IngressListenerBootstrapConfigurationFluent<?> fluent;
    Boolean validationEnabled;

    public IngressListenerBootstrapConfigurationBuilder(){
            this(true);
    }
    public IngressListenerBootstrapConfigurationBuilder(Boolean validationEnabled){
            this(new IngressListenerBootstrapConfiguration(), validationEnabled);
    }
    public IngressListenerBootstrapConfigurationBuilder(IngressListenerBootstrapConfigurationFluent<?> fluent){
            this(fluent, true);
    }
    public IngressListenerBootstrapConfigurationBuilder(IngressListenerBootstrapConfigurationFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new IngressListenerBootstrapConfiguration(), validationEnabled);
    }
    public IngressListenerBootstrapConfigurationBuilder(IngressListenerBootstrapConfigurationFluent<?> fluent,IngressListenerBootstrapConfiguration instance){
            this(fluent, instance, true);
    }
    public IngressListenerBootstrapConfigurationBuilder(IngressListenerBootstrapConfigurationFluent<?> fluent,IngressListenerBootstrapConfiguration instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withHost(instance.getHost());

            fluent.withDnsAnnotations(instance.getDnsAnnotations());

            fluent.withAddress(instance.getAddress());

            this.validationEnabled = validationEnabled; 
    }
    public IngressListenerBootstrapConfigurationBuilder(IngressListenerBootstrapConfiguration instance){
            this(instance,true);
    }
    public IngressListenerBootstrapConfigurationBuilder(IngressListenerBootstrapConfiguration instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withHost(instance.getHost());

            this.withDnsAnnotations(instance.getDnsAnnotations());

            this.withAddress(instance.getAddress());

            this.validationEnabled = validationEnabled; 
    }

    public IngressListenerBootstrapConfiguration build(){
            IngressListenerBootstrapConfiguration buildable = new IngressListenerBootstrapConfiguration();
            buildable.setAddress(fluent.getAddress());
            buildable.setHost(fluent.getHost());
            buildable.setDnsAnnotations(fluent.getDnsAnnotations());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            IngressListenerBootstrapConfigurationBuilder that = (IngressListenerBootstrapConfigurationBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
