package io.strimzi.api.kafka.model.connect;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class ExternalConfigurationFluentImpl<A extends ExternalConfigurationFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ExternalConfigurationFluent<A>{

    private List<ExternalConfigurationEnvBuilder> env;
    private List<ExternalConfigurationVolumeSourceBuilder> volumes;

    public ExternalConfigurationFluentImpl(){
    }
    public ExternalConfigurationFluentImpl(ExternalConfiguration instance){
            this.withEnv(instance.getEnv());

            this.withVolumes(instance.getVolumes());

    }

    public A addToEnv(int index,ExternalConfigurationEnv item){
            if (this.env == null) {this.env = new ArrayList<ExternalConfigurationEnvBuilder>();}
            ExternalConfigurationEnvBuilder builder = new ExternalConfigurationEnvBuilder(item);_visitables.get("env").add(index >= 0 ? index : _visitables.get("env").size(), builder);this.env.add(index >= 0 ? index : env.size(), builder); return (A)this;
    }

    public A setToEnv(int index,ExternalConfigurationEnv item){
            if (this.env == null) {this.env = new ArrayList<ExternalConfigurationEnvBuilder>();}
            ExternalConfigurationEnvBuilder builder = new ExternalConfigurationEnvBuilder(item);
            if (index < 0 || index >= _visitables.get("env").size()) { _visitables.get("env").add(builder); } else { _visitables.get("env").set(index, builder);}
            if (index < 0 || index >= env.size()) { env.add(builder); } else { env.set(index, builder);}
             return (A)this;
    }

    public A addToEnv(ExternalConfigurationEnv... items){
            if (this.env == null) {this.env = new ArrayList<ExternalConfigurationEnvBuilder>();}
            for (ExternalConfigurationEnv item : items) {ExternalConfigurationEnvBuilder builder = new ExternalConfigurationEnvBuilder(item);_visitables.get("env").add(builder);this.env.add(builder);} return (A)this;
    }

    public A addAllToEnv(Collection<ExternalConfigurationEnv> items){
            if (this.env == null) {this.env = new ArrayList<ExternalConfigurationEnvBuilder>();}
            for (ExternalConfigurationEnv item : items) {ExternalConfigurationEnvBuilder builder = new ExternalConfigurationEnvBuilder(item);_visitables.get("env").add(builder);this.env.add(builder);} return (A)this;
    }

    public A removeFromEnv(ExternalConfigurationEnv... items){
            for (ExternalConfigurationEnv item : items) {ExternalConfigurationEnvBuilder builder = new ExternalConfigurationEnvBuilder(item);_visitables.get("env").remove(builder);if (this.env != null) {this.env.remove(builder);}} return (A)this;
    }

    public A removeAllFromEnv(Collection<ExternalConfigurationEnv> items){
            for (ExternalConfigurationEnv item : items) {ExternalConfigurationEnvBuilder builder = new ExternalConfigurationEnvBuilder(item);_visitables.get("env").remove(builder);if (this.env != null) {this.env.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromEnv(io.fabric8.kubernetes.api.builder.Predicate<ExternalConfigurationEnvBuilder> predicate){
            if (env == null) return (A) this;
            final Iterator<ExternalConfigurationEnvBuilder> each = env.iterator();
            final List visitables = _visitables.get("env");
            while (each.hasNext()) {
              ExternalConfigurationEnvBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildEnv instead.
 * @return The buildable object.
 */
@Deprecated public List<ExternalConfigurationEnv> getEnv(){
            return build(env);
    }

    public List<ExternalConfigurationEnv> buildEnv(){
            return build(env);
    }

    public ExternalConfigurationEnv buildEnv(int index){
            return this.env.get(index).build();
    }

    public ExternalConfigurationEnv buildFirstEnv(){
            return this.env.get(0).build();
    }

    public ExternalConfigurationEnv buildLastEnv(){
            return this.env.get(env.size() - 1).build();
    }

    public ExternalConfigurationEnv buildMatchingEnv(io.fabric8.kubernetes.api.builder.Predicate<ExternalConfigurationEnvBuilder> predicate){
            for (ExternalConfigurationEnvBuilder item: env) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingEnv(io.fabric8.kubernetes.api.builder.Predicate<ExternalConfigurationEnvBuilder> predicate){
            for (ExternalConfigurationEnvBuilder item: env) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withEnv(List<ExternalConfigurationEnv> env){
            if (this.env != null) { _visitables.get("env").removeAll(this.env);}
            if (env != null) {this.env = new ArrayList<ExternalConfigurationEnvBuilder>(); for (ExternalConfigurationEnv item : env){this.addToEnv(item);}} else { this.env = null;} return (A) this;
    }

    public A withEnv(ExternalConfigurationEnv... env){
            if (this.env != null) {this.env.clear();}
            if (env != null) {for (ExternalConfigurationEnv item :env){ this.addToEnv(item);}} return (A) this;
    }

    public Boolean hasEnv(){
            return env != null && !env.isEmpty();
    }

    public ExternalConfigurationFluent.EnvNested<A> addNewEnv(){
            return new EnvNestedImpl();
    }

    public ExternalConfigurationFluent.EnvNested<A> addNewEnvLike(ExternalConfigurationEnv item){
            return new EnvNestedImpl(-1, item);
    }

    public ExternalConfigurationFluent.EnvNested<A> setNewEnvLike(int index,ExternalConfigurationEnv item){
            return new EnvNestedImpl(index, item);
    }

    public ExternalConfigurationFluent.EnvNested<A> editEnv(int index){
            if (env.size() <= index) throw new RuntimeException("Can't edit env. Index exceeds size.");
            return setNewEnvLike(index, buildEnv(index));
    }

    public ExternalConfigurationFluent.EnvNested<A> editFirstEnv(){
            if (env.size() == 0) throw new RuntimeException("Can't edit first env. The list is empty.");
            return setNewEnvLike(0, buildEnv(0));
    }

    public ExternalConfigurationFluent.EnvNested<A> editLastEnv(){
            int index = env.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last env. The list is empty.");
            return setNewEnvLike(index, buildEnv(index));
    }

    public ExternalConfigurationFluent.EnvNested<A> editMatchingEnv(io.fabric8.kubernetes.api.builder.Predicate<ExternalConfigurationEnvBuilder> predicate){
            int index = -1;
            for (int i=0;i<env.size();i++) { 
            if (predicate.apply(env.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching env. No match found.");
            return setNewEnvLike(index, buildEnv(index));
    }

    public A addToVolumes(int index,ExternalConfigurationVolumeSource item){
            if (this.volumes == null) {this.volumes = new ArrayList<ExternalConfigurationVolumeSourceBuilder>();}
            ExternalConfigurationVolumeSourceBuilder builder = new ExternalConfigurationVolumeSourceBuilder(item);_visitables.get("volumes").add(index >= 0 ? index : _visitables.get("volumes").size(), builder);this.volumes.add(index >= 0 ? index : volumes.size(), builder); return (A)this;
    }

    public A setToVolumes(int index,ExternalConfigurationVolumeSource item){
            if (this.volumes == null) {this.volumes = new ArrayList<ExternalConfigurationVolumeSourceBuilder>();}
            ExternalConfigurationVolumeSourceBuilder builder = new ExternalConfigurationVolumeSourceBuilder(item);
            if (index < 0 || index >= _visitables.get("volumes").size()) { _visitables.get("volumes").add(builder); } else { _visitables.get("volumes").set(index, builder);}
            if (index < 0 || index >= volumes.size()) { volumes.add(builder); } else { volumes.set(index, builder);}
             return (A)this;
    }

    public A addToVolumes(ExternalConfigurationVolumeSource... items){
            if (this.volumes == null) {this.volumes = new ArrayList<ExternalConfigurationVolumeSourceBuilder>();}
            for (ExternalConfigurationVolumeSource item : items) {ExternalConfigurationVolumeSourceBuilder builder = new ExternalConfigurationVolumeSourceBuilder(item);_visitables.get("volumes").add(builder);this.volumes.add(builder);} return (A)this;
    }

    public A addAllToVolumes(Collection<ExternalConfigurationVolumeSource> items){
            if (this.volumes == null) {this.volumes = new ArrayList<ExternalConfigurationVolumeSourceBuilder>();}
            for (ExternalConfigurationVolumeSource item : items) {ExternalConfigurationVolumeSourceBuilder builder = new ExternalConfigurationVolumeSourceBuilder(item);_visitables.get("volumes").add(builder);this.volumes.add(builder);} return (A)this;
    }

    public A removeFromVolumes(ExternalConfigurationVolumeSource... items){
            for (ExternalConfigurationVolumeSource item : items) {ExternalConfigurationVolumeSourceBuilder builder = new ExternalConfigurationVolumeSourceBuilder(item);_visitables.get("volumes").remove(builder);if (this.volumes != null) {this.volumes.remove(builder);}} return (A)this;
    }

    public A removeAllFromVolumes(Collection<ExternalConfigurationVolumeSource> items){
            for (ExternalConfigurationVolumeSource item : items) {ExternalConfigurationVolumeSourceBuilder builder = new ExternalConfigurationVolumeSourceBuilder(item);_visitables.get("volumes").remove(builder);if (this.volumes != null) {this.volumes.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromVolumes(io.fabric8.kubernetes.api.builder.Predicate<ExternalConfigurationVolumeSourceBuilder> predicate){
            if (volumes == null) return (A) this;
            final Iterator<ExternalConfigurationVolumeSourceBuilder> each = volumes.iterator();
            final List visitables = _visitables.get("volumes");
            while (each.hasNext()) {
              ExternalConfigurationVolumeSourceBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildVolumes instead.
 * @return The buildable object.
 */
@Deprecated public List<ExternalConfigurationVolumeSource> getVolumes(){
            return build(volumes);
    }

    public List<ExternalConfigurationVolumeSource> buildVolumes(){
            return build(volumes);
    }

    public ExternalConfigurationVolumeSource buildVolume(int index){
            return this.volumes.get(index).build();
    }

    public ExternalConfigurationVolumeSource buildFirstVolume(){
            return this.volumes.get(0).build();
    }

    public ExternalConfigurationVolumeSource buildLastVolume(){
            return this.volumes.get(volumes.size() - 1).build();
    }

    public ExternalConfigurationVolumeSource buildMatchingVolume(io.fabric8.kubernetes.api.builder.Predicate<ExternalConfigurationVolumeSourceBuilder> predicate){
            for (ExternalConfigurationVolumeSourceBuilder item: volumes) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingVolume(io.fabric8.kubernetes.api.builder.Predicate<ExternalConfigurationVolumeSourceBuilder> predicate){
            for (ExternalConfigurationVolumeSourceBuilder item: volumes) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withVolumes(List<ExternalConfigurationVolumeSource> volumes){
            if (this.volumes != null) { _visitables.get("volumes").removeAll(this.volumes);}
            if (volumes != null) {this.volumes = new ArrayList<ExternalConfigurationVolumeSourceBuilder>(); for (ExternalConfigurationVolumeSource item : volumes){this.addToVolumes(item);}} else { this.volumes = null;} return (A) this;
    }

    public A withVolumes(ExternalConfigurationVolumeSource... volumes){
            if (this.volumes != null) {this.volumes.clear();}
            if (volumes != null) {for (ExternalConfigurationVolumeSource item :volumes){ this.addToVolumes(item);}} return (A) this;
    }

    public Boolean hasVolumes(){
            return volumes != null && !volumes.isEmpty();
    }

    public ExternalConfigurationFluent.VolumesNested<A> addNewVolume(){
            return new VolumesNestedImpl();
    }

    public ExternalConfigurationFluent.VolumesNested<A> addNewVolumeLike(ExternalConfigurationVolumeSource item){
            return new VolumesNestedImpl(-1, item);
    }

    public ExternalConfigurationFluent.VolumesNested<A> setNewVolumeLike(int index,ExternalConfigurationVolumeSource item){
            return new VolumesNestedImpl(index, item);
    }

    public ExternalConfigurationFluent.VolumesNested<A> editVolume(int index){
            if (volumes.size() <= index) throw new RuntimeException("Can't edit volumes. Index exceeds size.");
            return setNewVolumeLike(index, buildVolume(index));
    }

    public ExternalConfigurationFluent.VolumesNested<A> editFirstVolume(){
            if (volumes.size() == 0) throw new RuntimeException("Can't edit first volumes. The list is empty.");
            return setNewVolumeLike(0, buildVolume(0));
    }

    public ExternalConfigurationFluent.VolumesNested<A> editLastVolume(){
            int index = volumes.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last volumes. The list is empty.");
            return setNewVolumeLike(index, buildVolume(index));
    }

    public ExternalConfigurationFluent.VolumesNested<A> editMatchingVolume(io.fabric8.kubernetes.api.builder.Predicate<ExternalConfigurationVolumeSourceBuilder> predicate){
            int index = -1;
            for (int i=0;i<volumes.size();i++) { 
            if (predicate.apply(volumes.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching volumes. No match found.");
            return setNewVolumeLike(index, buildVolume(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            ExternalConfigurationFluentImpl that = (ExternalConfigurationFluentImpl) o;
            if (env != null ? !env.equals(that.env) :that.env != null) return false;
            if (volumes != null ? !volumes.equals(that.volumes) :that.volumes != null) return false;
            return true;
    }


    public class EnvNestedImpl<N> extends ExternalConfigurationEnvFluentImpl<ExternalConfigurationFluent.EnvNested<N>> implements ExternalConfigurationFluent.EnvNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ExternalConfigurationEnvBuilder builder;
        private final int index;
    
            EnvNestedImpl(int index,ExternalConfigurationEnv item){
                    this.index = index;
                    this.builder = new ExternalConfigurationEnvBuilder(this, item);
            }
            EnvNestedImpl(){
                    this.index = -1;
                    this.builder = new ExternalConfigurationEnvBuilder(this);
            }
    
    public N and(){
            return (N) ExternalConfigurationFluentImpl.this.setToEnv(index, builder.build());
    }
    public N endEnv(){
            return and();
    }

}
    public class VolumesNestedImpl<N> extends ExternalConfigurationVolumeSourceFluentImpl<ExternalConfigurationFluent.VolumesNested<N>> implements ExternalConfigurationFluent.VolumesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ExternalConfigurationVolumeSourceBuilder builder;
        private final int index;
    
            VolumesNestedImpl(int index,ExternalConfigurationVolumeSource item){
                    this.index = index;
                    this.builder = new ExternalConfigurationVolumeSourceBuilder(this, item);
            }
            VolumesNestedImpl(){
                    this.index = -1;
                    this.builder = new ExternalConfigurationVolumeSourceBuilder(this);
            }
    
    public N and(){
            return (N) ExternalConfigurationFluentImpl.this.setToVolumes(index, builder.build());
    }
    public N endVolume(){
            return and();
    }

}


}
