package io.strimzi.api.kafka.model.connect;

import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class ExternalConfigurationEnvFluentImpl<A extends ExternalConfigurationEnvFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ExternalConfigurationEnvFluent<A>{

    private String name;
    private ExternalConfigurationEnvVarSourceBuilder valueFrom;

    public ExternalConfigurationEnvFluentImpl(){
    }
    public ExternalConfigurationEnvFluentImpl(ExternalConfigurationEnv instance){
            this.withName(instance.getName());

            this.withValueFrom(instance.getValueFrom());

    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    public A withNewName(String arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1){
            return (A)withName(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildValueFrom instead.
 * @return The buildable object.
 */
@Deprecated public ExternalConfigurationEnvVarSource getValueFrom(){
            return this.valueFrom!=null?this.valueFrom.build():null;
    }

    public ExternalConfigurationEnvVarSource buildValueFrom(){
            return this.valueFrom!=null?this.valueFrom.build():null;
    }

    public A withValueFrom(ExternalConfigurationEnvVarSource valueFrom){
            _visitables.get("valueFrom").remove(this.valueFrom);
            if (valueFrom!=null){ this.valueFrom= new ExternalConfigurationEnvVarSourceBuilder(valueFrom); _visitables.get("valueFrom").add(this.valueFrom);} return (A) this;
    }

    public Boolean hasValueFrom(){
            return this.valueFrom != null;
    }

    public ExternalConfigurationEnvFluent.ValueFromNested<A> withNewValueFrom(){
            return new ValueFromNestedImpl();
    }

    public ExternalConfigurationEnvFluent.ValueFromNested<A> withNewValueFromLike(ExternalConfigurationEnvVarSource item){
            return new ValueFromNestedImpl(item);
    }

    public ExternalConfigurationEnvFluent.ValueFromNested<A> editValueFrom(){
            return withNewValueFromLike(getValueFrom());
    }

    public ExternalConfigurationEnvFluent.ValueFromNested<A> editOrNewValueFrom(){
            return withNewValueFromLike(getValueFrom() != null ? getValueFrom(): new ExternalConfigurationEnvVarSourceBuilder().build());
    }

    public ExternalConfigurationEnvFluent.ValueFromNested<A> editOrNewValueFromLike(ExternalConfigurationEnvVarSource item){
            return withNewValueFromLike(getValueFrom() != null ? getValueFrom(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            ExternalConfigurationEnvFluentImpl that = (ExternalConfigurationEnvFluentImpl) o;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (valueFrom != null ? !valueFrom.equals(that.valueFrom) :that.valueFrom != null) return false;
            return true;
    }


    public class ValueFromNestedImpl<N> extends ExternalConfigurationEnvVarSourceFluentImpl<ExternalConfigurationEnvFluent.ValueFromNested<N>> implements ExternalConfigurationEnvFluent.ValueFromNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ExternalConfigurationEnvVarSourceBuilder builder;
    
            ValueFromNestedImpl(ExternalConfigurationEnvVarSource item){
                    this.builder = new ExternalConfigurationEnvVarSourceBuilder(this, item);
            }
            ValueFromNestedImpl(){
                    this.builder = new ExternalConfigurationEnvVarSourceBuilder(this);
            }
    
    public N and(){
            return (N) ExternalConfigurationEnvFluentImpl.this.withValueFrom(builder.build());
    }
    public N endValueFrom(){
            return and();
    }

}


}
