package io.strimzi.api.kafka.model.authentication;

import java.lang.StringBuffer;
import java.lang.StringBuilder;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.PasswordSecretSource;
import java.lang.String;
import io.strimzi.api.kafka.model.PasswordSecretSourceFluent;
import java.lang.Boolean;
import io.strimzi.api.kafka.model.PasswordSecretSourceBuilder;

public interface KafkaClientAuthenticationPlainFluent<A extends KafkaClientAuthenticationPlainFluent<A>> extends Fluent<A>{


    public String getUsername();
    public A withUsername(String username);
    public Boolean hasUsername();
    public A withNewUsername(String arg1);
    public A withNewUsername(StringBuilder arg1);
    public A withNewUsername(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildPasswordSecret instead.
 * @return The buildable object.
 */
@Deprecated public PasswordSecretSource getPasswordSecret();
    public PasswordSecretSource buildPasswordSecret();
    public A withPasswordSecret(PasswordSecretSource passwordSecret);
    public Boolean hasPasswordSecret();
    public KafkaClientAuthenticationPlainFluent.PasswordSecretNested<A> withNewPasswordSecret();
    public KafkaClientAuthenticationPlainFluent.PasswordSecretNested<A> withNewPasswordSecretLike(PasswordSecretSource item);
    public KafkaClientAuthenticationPlainFluent.PasswordSecretNested<A> editPasswordSecret();
    public KafkaClientAuthenticationPlainFluent.PasswordSecretNested<A> editOrNewPasswordSecret();
    public KafkaClientAuthenticationPlainFluent.PasswordSecretNested<A> editOrNewPasswordSecretLike(PasswordSecretSource item);

    public interface PasswordSecretNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PasswordSecretSourceFluent<KafkaClientAuthenticationPlainFluent.PasswordSecretNested<N>>{

        
    public N and();    public N endPasswordSecret();
}


}
