package io.strimzi.api.kafka.model.authentication;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaClientAuthenticationPlainBuilder extends KafkaClientAuthenticationPlainFluentImpl<KafkaClientAuthenticationPlainBuilder> implements VisitableBuilder<KafkaClientAuthenticationPlain,KafkaClientAuthenticationPlainBuilder>{

    KafkaClientAuthenticationPlainFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaClientAuthenticationPlainBuilder(){
            this(true);
    }
    public KafkaClientAuthenticationPlainBuilder(Boolean validationEnabled){
            this(new KafkaClientAuthenticationPlain(), validationEnabled);
    }
    public KafkaClientAuthenticationPlainBuilder(KafkaClientAuthenticationPlainFluent<?> fluent){
            this(fluent, true);
    }
    public KafkaClientAuthenticationPlainBuilder(KafkaClientAuthenticationPlainFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new KafkaClientAuthenticationPlain(), validationEnabled);
    }
    public KafkaClientAuthenticationPlainBuilder(KafkaClientAuthenticationPlainFluent<?> fluent,KafkaClientAuthenticationPlain instance){
            this(fluent, instance, true);
    }
    public KafkaClientAuthenticationPlainBuilder(KafkaClientAuthenticationPlainFluent<?> fluent,KafkaClientAuthenticationPlain instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withUsername(instance.getUsername());

            fluent.withPasswordSecret(instance.getPasswordSecret());

            this.validationEnabled = validationEnabled; 
    }
    public KafkaClientAuthenticationPlainBuilder(KafkaClientAuthenticationPlain instance){
            this(instance,true);
    }
    public KafkaClientAuthenticationPlainBuilder(KafkaClientAuthenticationPlain instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withUsername(instance.getUsername());

            this.withPasswordSecret(instance.getPasswordSecret());

            this.validationEnabled = validationEnabled; 
    }

    public KafkaClientAuthenticationPlain build(){
            KafkaClientAuthenticationPlain buildable = new KafkaClientAuthenticationPlain();
            buildable.setUsername(fluent.getUsername());
            buildable.setPasswordSecret(fluent.getPasswordSecret());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KafkaClientAuthenticationPlainBuilder that = (KafkaClientAuthenticationPlainBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
