package io.strimzi.api.kafka.model.authentication;

import io.strimzi.api.kafka.model.GenericSecretSource;
import io.strimzi.api.kafka.model.GenericSecretSourceBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.CertSecretSourceFluentImpl;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.GenericSecretSourceFluentImpl;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.StringBuffer;
import io.strimzi.api.kafka.model.CertSecretSourceBuilder;
import java.util.Collection;
import java.lang.Object;
import io.strimzi.api.kafka.model.CertSecretSource;

public class KafkaClientAuthenticationOAuthFluentImpl<A extends KafkaClientAuthenticationOAuthFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements KafkaClientAuthenticationOAuthFluent<A>{

    private String clientId;
    private String tokenEndpointUri;
    private GenericSecretSourceBuilder clientSecret;
    private GenericSecretSourceBuilder accessToken;
    private GenericSecretSourceBuilder refreshToken;
    private List<CertSecretSourceBuilder> tlsTrustedCertificates;
    private boolean disableTlsHostnameVerification;
    private int maxTokenExpirySeconds;
    private boolean accessTokenIsJwt;

    public KafkaClientAuthenticationOAuthFluentImpl(){
    }
    public KafkaClientAuthenticationOAuthFluentImpl(KafkaClientAuthenticationOAuth instance){
            this.withClientId(instance.getClientId());

            this.withTokenEndpointUri(instance.getTokenEndpointUri());

            this.withClientSecret(instance.getClientSecret());

            this.withAccessToken(instance.getAccessToken());

            this.withRefreshToken(instance.getRefreshToken());

            this.withTlsTrustedCertificates(instance.getTlsTrustedCertificates());

            this.withDisableTlsHostnameVerification(instance.isDisableTlsHostnameVerification());

            this.withMaxTokenExpirySeconds(instance.getMaxTokenExpirySeconds());

            this.withAccessTokenIsJwt(instance.isAccessTokenIsJwt());

    }

    public String getClientId(){
            return this.clientId;
    }

    public A withClientId(String clientId){
            this.clientId=clientId; return (A) this;
    }

    public Boolean hasClientId(){
            return this.clientId != null;
    }

    public A withNewClientId(String arg1){
            return (A)withClientId(new String(arg1));
    }

    public A withNewClientId(StringBuilder arg1){
            return (A)withClientId(new String(arg1));
    }

    public A withNewClientId(StringBuffer arg1){
            return (A)withClientId(new String(arg1));
    }

    public String getTokenEndpointUri(){
            return this.tokenEndpointUri;
    }

    public A withTokenEndpointUri(String tokenEndpointUri){
            this.tokenEndpointUri=tokenEndpointUri; return (A) this;
    }

    public Boolean hasTokenEndpointUri(){
            return this.tokenEndpointUri != null;
    }

    public A withNewTokenEndpointUri(String arg1){
            return (A)withTokenEndpointUri(new String(arg1));
    }

    public A withNewTokenEndpointUri(StringBuilder arg1){
            return (A)withTokenEndpointUri(new String(arg1));
    }

    public A withNewTokenEndpointUri(StringBuffer arg1){
            return (A)withTokenEndpointUri(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildClientSecret instead.
 * @return The buildable object.
 */
@Deprecated public GenericSecretSource getClientSecret(){
            return this.clientSecret!=null?this.clientSecret.build():null;
    }

    public GenericSecretSource buildClientSecret(){
            return this.clientSecret!=null?this.clientSecret.build():null;
    }

    public A withClientSecret(GenericSecretSource clientSecret){
            _visitables.get("clientSecret").remove(this.clientSecret);
            if (clientSecret!=null){ this.clientSecret= new GenericSecretSourceBuilder(clientSecret); _visitables.get("clientSecret").add(this.clientSecret);} return (A) this;
    }

    public Boolean hasClientSecret(){
            return this.clientSecret != null;
    }

    public KafkaClientAuthenticationOAuthFluent.ClientSecretNested<A> withNewClientSecret(){
            return new ClientSecretNestedImpl();
    }

    public KafkaClientAuthenticationOAuthFluent.ClientSecretNested<A> withNewClientSecretLike(GenericSecretSource item){
            return new ClientSecretNestedImpl(item);
    }

    public KafkaClientAuthenticationOAuthFluent.ClientSecretNested<A> editClientSecret(){
            return withNewClientSecretLike(getClientSecret());
    }

    public KafkaClientAuthenticationOAuthFluent.ClientSecretNested<A> editOrNewClientSecret(){
            return withNewClientSecretLike(getClientSecret() != null ? getClientSecret(): new GenericSecretSourceBuilder().build());
    }

    public KafkaClientAuthenticationOAuthFluent.ClientSecretNested<A> editOrNewClientSecretLike(GenericSecretSource item){
            return withNewClientSecretLike(getClientSecret() != null ? getClientSecret(): item);
    }

    
/**
 * This method has been deprecated, please use method buildAccessToken instead.
 * @return The buildable object.
 */
@Deprecated public GenericSecretSource getAccessToken(){
            return this.accessToken!=null?this.accessToken.build():null;
    }

    public GenericSecretSource buildAccessToken(){
            return this.accessToken!=null?this.accessToken.build():null;
    }

    public A withAccessToken(GenericSecretSource accessToken){
            _visitables.get("accessToken").remove(this.accessToken);
            if (accessToken!=null){ this.accessToken= new GenericSecretSourceBuilder(accessToken); _visitables.get("accessToken").add(this.accessToken);} return (A) this;
    }

    public Boolean hasAccessToken(){
            return this.accessToken != null;
    }

    public KafkaClientAuthenticationOAuthFluent.AccessTokenNested<A> withNewAccessToken(){
            return new AccessTokenNestedImpl();
    }

    public KafkaClientAuthenticationOAuthFluent.AccessTokenNested<A> withNewAccessTokenLike(GenericSecretSource item){
            return new AccessTokenNestedImpl(item);
    }

    public KafkaClientAuthenticationOAuthFluent.AccessTokenNested<A> editAccessToken(){
            return withNewAccessTokenLike(getAccessToken());
    }

    public KafkaClientAuthenticationOAuthFluent.AccessTokenNested<A> editOrNewAccessToken(){
            return withNewAccessTokenLike(getAccessToken() != null ? getAccessToken(): new GenericSecretSourceBuilder().build());
    }

    public KafkaClientAuthenticationOAuthFluent.AccessTokenNested<A> editOrNewAccessTokenLike(GenericSecretSource item){
            return withNewAccessTokenLike(getAccessToken() != null ? getAccessToken(): item);
    }

    
/**
 * This method has been deprecated, please use method buildRefreshToken instead.
 * @return The buildable object.
 */
@Deprecated public GenericSecretSource getRefreshToken(){
            return this.refreshToken!=null?this.refreshToken.build():null;
    }

    public GenericSecretSource buildRefreshToken(){
            return this.refreshToken!=null?this.refreshToken.build():null;
    }

    public A withRefreshToken(GenericSecretSource refreshToken){
            _visitables.get("refreshToken").remove(this.refreshToken);
            if (refreshToken!=null){ this.refreshToken= new GenericSecretSourceBuilder(refreshToken); _visitables.get("refreshToken").add(this.refreshToken);} return (A) this;
    }

    public Boolean hasRefreshToken(){
            return this.refreshToken != null;
    }

    public KafkaClientAuthenticationOAuthFluent.RefreshTokenNested<A> withNewRefreshToken(){
            return new RefreshTokenNestedImpl();
    }

    public KafkaClientAuthenticationOAuthFluent.RefreshTokenNested<A> withNewRefreshTokenLike(GenericSecretSource item){
            return new RefreshTokenNestedImpl(item);
    }

    public KafkaClientAuthenticationOAuthFluent.RefreshTokenNested<A> editRefreshToken(){
            return withNewRefreshTokenLike(getRefreshToken());
    }

    public KafkaClientAuthenticationOAuthFluent.RefreshTokenNested<A> editOrNewRefreshToken(){
            return withNewRefreshTokenLike(getRefreshToken() != null ? getRefreshToken(): new GenericSecretSourceBuilder().build());
    }

    public KafkaClientAuthenticationOAuthFluent.RefreshTokenNested<A> editOrNewRefreshTokenLike(GenericSecretSource item){
            return withNewRefreshTokenLike(getRefreshToken() != null ? getRefreshToken(): item);
    }

    public A addToTlsTrustedCertificates(int index,CertSecretSource item){
            if (this.tlsTrustedCertificates == null) {this.tlsTrustedCertificates = new ArrayList<CertSecretSourceBuilder>();}
            CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);_visitables.get("tlsTrustedCertificates").add(index >= 0 ? index : _visitables.get("tlsTrustedCertificates").size(), builder);this.tlsTrustedCertificates.add(index >= 0 ? index : tlsTrustedCertificates.size(), builder); return (A)this;
    }

    public A setToTlsTrustedCertificates(int index,CertSecretSource item){
            if (this.tlsTrustedCertificates == null) {this.tlsTrustedCertificates = new ArrayList<CertSecretSourceBuilder>();}
            CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
            if (index < 0 || index >= _visitables.get("tlsTrustedCertificates").size()) { _visitables.get("tlsTrustedCertificates").add(builder); } else { _visitables.get("tlsTrustedCertificates").set(index, builder);}
            if (index < 0 || index >= tlsTrustedCertificates.size()) { tlsTrustedCertificates.add(builder); } else { tlsTrustedCertificates.set(index, builder);}
             return (A)this;
    }

    public A addToTlsTrustedCertificates(CertSecretSource... items){
            if (this.tlsTrustedCertificates == null) {this.tlsTrustedCertificates = new ArrayList<CertSecretSourceBuilder>();}
            for (CertSecretSource item : items) {CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);_visitables.get("tlsTrustedCertificates").add(builder);this.tlsTrustedCertificates.add(builder);} return (A)this;
    }

    public A addAllToTlsTrustedCertificates(Collection<CertSecretSource> items){
            if (this.tlsTrustedCertificates == null) {this.tlsTrustedCertificates = new ArrayList<CertSecretSourceBuilder>();}
            for (CertSecretSource item : items) {CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);_visitables.get("tlsTrustedCertificates").add(builder);this.tlsTrustedCertificates.add(builder);} return (A)this;
    }

    public A removeFromTlsTrustedCertificates(CertSecretSource... items){
            for (CertSecretSource item : items) {CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);_visitables.get("tlsTrustedCertificates").remove(builder);if (this.tlsTrustedCertificates != null) {this.tlsTrustedCertificates.remove(builder);}} return (A)this;
    }

    public A removeAllFromTlsTrustedCertificates(Collection<CertSecretSource> items){
            for (CertSecretSource item : items) {CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);_visitables.get("tlsTrustedCertificates").remove(builder);if (this.tlsTrustedCertificates != null) {this.tlsTrustedCertificates.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromTlsTrustedCertificates(io.fabric8.kubernetes.api.builder.Predicate<CertSecretSourceBuilder> predicate){
            if (tlsTrustedCertificates == null) return (A) this;
            final Iterator<CertSecretSourceBuilder> each = tlsTrustedCertificates.iterator();
            final List visitables = _visitables.get("tlsTrustedCertificates");
            while (each.hasNext()) {
              CertSecretSourceBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildTlsTrustedCertificates instead.
 * @return The buildable object.
 */
@Deprecated public List<CertSecretSource> getTlsTrustedCertificates(){
            return build(tlsTrustedCertificates);
    }

    public List<CertSecretSource> buildTlsTrustedCertificates(){
            return build(tlsTrustedCertificates);
    }

    public CertSecretSource buildTlsTrustedCertificate(int index){
            return this.tlsTrustedCertificates.get(index).build();
    }

    public CertSecretSource buildFirstTlsTrustedCertificate(){
            return this.tlsTrustedCertificates.get(0).build();
    }

    public CertSecretSource buildLastTlsTrustedCertificate(){
            return this.tlsTrustedCertificates.get(tlsTrustedCertificates.size() - 1).build();
    }

    public CertSecretSource buildMatchingTlsTrustedCertificate(io.fabric8.kubernetes.api.builder.Predicate<CertSecretSourceBuilder> predicate){
            for (CertSecretSourceBuilder item: tlsTrustedCertificates) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingTlsTrustedCertificate(io.fabric8.kubernetes.api.builder.Predicate<CertSecretSourceBuilder> predicate){
            for (CertSecretSourceBuilder item: tlsTrustedCertificates) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withTlsTrustedCertificates(List<CertSecretSource> tlsTrustedCertificates){
            if (this.tlsTrustedCertificates != null) { _visitables.get("tlsTrustedCertificates").removeAll(this.tlsTrustedCertificates);}
            if (tlsTrustedCertificates != null) {this.tlsTrustedCertificates = new ArrayList<CertSecretSourceBuilder>(); for (CertSecretSource item : tlsTrustedCertificates){this.addToTlsTrustedCertificates(item);}} else { this.tlsTrustedCertificates = null;} return (A) this;
    }

    public A withTlsTrustedCertificates(CertSecretSource... tlsTrustedCertificates){
            if (this.tlsTrustedCertificates != null) {this.tlsTrustedCertificates.clear();}
            if (tlsTrustedCertificates != null) {for (CertSecretSource item :tlsTrustedCertificates){ this.addToTlsTrustedCertificates(item);}} return (A) this;
    }

    public Boolean hasTlsTrustedCertificates(){
            return tlsTrustedCertificates != null && !tlsTrustedCertificates.isEmpty();
    }

    public KafkaClientAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> addNewTlsTrustedCertificate(){
            return new TlsTrustedCertificatesNestedImpl();
    }

    public KafkaClientAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> addNewTlsTrustedCertificateLike(CertSecretSource item){
            return new TlsTrustedCertificatesNestedImpl(-1, item);
    }

    public KafkaClientAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> setNewTlsTrustedCertificateLike(int index,CertSecretSource item){
            return new TlsTrustedCertificatesNestedImpl(index, item);
    }

    public KafkaClientAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> editTlsTrustedCertificate(int index){
            if (tlsTrustedCertificates.size() <= index) throw new RuntimeException("Can't edit tlsTrustedCertificates. Index exceeds size.");
            return setNewTlsTrustedCertificateLike(index, buildTlsTrustedCertificate(index));
    }

    public KafkaClientAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> editFirstTlsTrustedCertificate(){
            if (tlsTrustedCertificates.size() == 0) throw new RuntimeException("Can't edit first tlsTrustedCertificates. The list is empty.");
            return setNewTlsTrustedCertificateLike(0, buildTlsTrustedCertificate(0));
    }

    public KafkaClientAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> editLastTlsTrustedCertificate(){
            int index = tlsTrustedCertificates.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last tlsTrustedCertificates. The list is empty.");
            return setNewTlsTrustedCertificateLike(index, buildTlsTrustedCertificate(index));
    }

    public KafkaClientAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> editMatchingTlsTrustedCertificate(io.fabric8.kubernetes.api.builder.Predicate<CertSecretSourceBuilder> predicate){
            int index = -1;
            for (int i=0;i<tlsTrustedCertificates.size();i++) { 
            if (predicate.apply(tlsTrustedCertificates.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching tlsTrustedCertificates. No match found.");
            return setNewTlsTrustedCertificateLike(index, buildTlsTrustedCertificate(index));
    }

    public boolean isDisableTlsHostnameVerification(){
            return this.disableTlsHostnameVerification;
    }

    public A withDisableTlsHostnameVerification(boolean disableTlsHostnameVerification){
            this.disableTlsHostnameVerification=disableTlsHostnameVerification; return (A) this;
    }

    public Boolean hasDisableTlsHostnameVerification(){
            return true;
    }

    public int getMaxTokenExpirySeconds(){
            return this.maxTokenExpirySeconds;
    }

    public A withMaxTokenExpirySeconds(int maxTokenExpirySeconds){
            this.maxTokenExpirySeconds=maxTokenExpirySeconds; return (A) this;
    }

    public Boolean hasMaxTokenExpirySeconds(){
            return true;
    }

    public boolean isAccessTokenIsJwt(){
            return this.accessTokenIsJwt;
    }

    public A withAccessTokenIsJwt(boolean accessTokenIsJwt){
            this.accessTokenIsJwt=accessTokenIsJwt; return (A) this;
    }

    public Boolean hasAccessTokenIsJwt(){
            return true;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            KafkaClientAuthenticationOAuthFluentImpl that = (KafkaClientAuthenticationOAuthFluentImpl) o;
            if (clientId != null ? !clientId.equals(that.clientId) :that.clientId != null) return false;
            if (tokenEndpointUri != null ? !tokenEndpointUri.equals(that.tokenEndpointUri) :that.tokenEndpointUri != null) return false;
            if (clientSecret != null ? !clientSecret.equals(that.clientSecret) :that.clientSecret != null) return false;
            if (accessToken != null ? !accessToken.equals(that.accessToken) :that.accessToken != null) return false;
            if (refreshToken != null ? !refreshToken.equals(that.refreshToken) :that.refreshToken != null) return false;
            if (tlsTrustedCertificates != null ? !tlsTrustedCertificates.equals(that.tlsTrustedCertificates) :that.tlsTrustedCertificates != null) return false;
            if (disableTlsHostnameVerification != that.disableTlsHostnameVerification) return false;
            if (maxTokenExpirySeconds != that.maxTokenExpirySeconds) return false;
            if (accessTokenIsJwt != that.accessTokenIsJwt) return false;
            return true;
    }


    public class ClientSecretNestedImpl<N> extends GenericSecretSourceFluentImpl<KafkaClientAuthenticationOAuthFluent.ClientSecretNested<N>> implements KafkaClientAuthenticationOAuthFluent.ClientSecretNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final GenericSecretSourceBuilder builder;
    
            ClientSecretNestedImpl(GenericSecretSource item){
                    this.builder = new GenericSecretSourceBuilder(this, item);
            }
            ClientSecretNestedImpl(){
                    this.builder = new GenericSecretSourceBuilder(this);
            }
    
    public N and(){
            return (N) KafkaClientAuthenticationOAuthFluentImpl.this.withClientSecret(builder.build());
    }
    public N endClientSecret(){
            return and();
    }

}
    public class AccessTokenNestedImpl<N> extends GenericSecretSourceFluentImpl<KafkaClientAuthenticationOAuthFluent.AccessTokenNested<N>> implements KafkaClientAuthenticationOAuthFluent.AccessTokenNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final GenericSecretSourceBuilder builder;
    
            AccessTokenNestedImpl(GenericSecretSource item){
                    this.builder = new GenericSecretSourceBuilder(this, item);
            }
            AccessTokenNestedImpl(){
                    this.builder = new GenericSecretSourceBuilder(this);
            }
    
    public N and(){
            return (N) KafkaClientAuthenticationOAuthFluentImpl.this.withAccessToken(builder.build());
    }
    public N endAccessToken(){
            return and();
    }

}
    public class RefreshTokenNestedImpl<N> extends GenericSecretSourceFluentImpl<KafkaClientAuthenticationOAuthFluent.RefreshTokenNested<N>> implements KafkaClientAuthenticationOAuthFluent.RefreshTokenNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final GenericSecretSourceBuilder builder;
    
            RefreshTokenNestedImpl(GenericSecretSource item){
                    this.builder = new GenericSecretSourceBuilder(this, item);
            }
            RefreshTokenNestedImpl(){
                    this.builder = new GenericSecretSourceBuilder(this);
            }
    
    public N and(){
            return (N) KafkaClientAuthenticationOAuthFluentImpl.this.withRefreshToken(builder.build());
    }
    public N endRefreshToken(){
            return and();
    }

}
    public class TlsTrustedCertificatesNestedImpl<N> extends CertSecretSourceFluentImpl<KafkaClientAuthenticationOAuthFluent.TlsTrustedCertificatesNested<N>> implements KafkaClientAuthenticationOAuthFluent.TlsTrustedCertificatesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final CertSecretSourceBuilder builder;
        private final int index;
    
            TlsTrustedCertificatesNestedImpl(int index,CertSecretSource item){
                    this.index = index;
                    this.builder = new CertSecretSourceBuilder(this, item);
            }
            TlsTrustedCertificatesNestedImpl(){
                    this.index = -1;
                    this.builder = new CertSecretSourceBuilder(this);
            }
    
    public N and(){
            return (N) KafkaClientAuthenticationOAuthFluentImpl.this.setToTlsTrustedCertificates(index, builder.build());
    }
    public N endTlsTrustedCertificate(){
            return and();
    }

}


}
