package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ZookeeperClusterSpecBuilder extends ZookeeperClusterSpecFluentImpl<ZookeeperClusterSpecBuilder> implements VisitableBuilder<ZookeeperClusterSpec,ZookeeperClusterSpecBuilder>{

    ZookeeperClusterSpecFluent<?> fluent;
    Boolean validationEnabled;

    public ZookeeperClusterSpecBuilder(){
            this(true);
    }
    public ZookeeperClusterSpecBuilder(Boolean validationEnabled){
            this(new ZookeeperClusterSpec(), validationEnabled);
    }
    public ZookeeperClusterSpecBuilder(ZookeeperClusterSpecFluent<?> fluent){
            this(fluent, true);
    }
    public ZookeeperClusterSpecBuilder(ZookeeperClusterSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ZookeeperClusterSpec(), validationEnabled);
    }
    public ZookeeperClusterSpecBuilder(ZookeeperClusterSpecFluent<?> fluent,ZookeeperClusterSpec instance){
            this(fluent, instance, true);
    }
    public ZookeeperClusterSpecBuilder(ZookeeperClusterSpecFluent<?> fluent,ZookeeperClusterSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withStorage(instance.getStorage());

            fluent.withConfig(instance.getConfig());

            fluent.withLogging(instance.getLogging());

            fluent.withTlsSidecar(instance.getTlsSidecar());

            fluent.withReplicas(instance.getReplicas());

            fluent.withImage(instance.getImage());

            fluent.withResources(instance.getResources());

            fluent.withLivenessProbe(instance.getLivenessProbe());

            fluent.withReadinessProbe(instance.getReadinessProbe());

            fluent.withJvmOptions(instance.getJvmOptions());

            fluent.withMetrics(instance.getMetrics());

            fluent.withAffinity(instance.getAffinity());

            fluent.withTolerations(instance.getTolerations());

            fluent.withTemplate(instance.getTemplate());

            this.validationEnabled = validationEnabled; 
    }
    public ZookeeperClusterSpecBuilder(ZookeeperClusterSpec instance){
            this(instance,true);
    }
    public ZookeeperClusterSpecBuilder(ZookeeperClusterSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withStorage(instance.getStorage());

            this.withConfig(instance.getConfig());

            this.withLogging(instance.getLogging());

            this.withTlsSidecar(instance.getTlsSidecar());

            this.withReplicas(instance.getReplicas());

            this.withImage(instance.getImage());

            this.withResources(instance.getResources());

            this.withLivenessProbe(instance.getLivenessProbe());

            this.withReadinessProbe(instance.getReadinessProbe());

            this.withJvmOptions(instance.getJvmOptions());

            this.withMetrics(instance.getMetrics());

            this.withAffinity(instance.getAffinity());

            this.withTolerations(instance.getTolerations());

            this.withTemplate(instance.getTemplate());

            this.validationEnabled = validationEnabled; 
    }

    public ZookeeperClusterSpec build(){
            ZookeeperClusterSpec buildable = new ZookeeperClusterSpec();
            buildable.setStorage(fluent.getStorage());
            buildable.setConfig(fluent.getConfig());
            buildable.setLogging(fluent.getLogging());
            buildable.setTlsSidecar(fluent.getTlsSidecar());
            buildable.setReplicas(fluent.getReplicas());
            buildable.setImage(fluent.getImage());
            buildable.setResources(fluent.getResources());
            buildable.setLivenessProbe(fluent.getLivenessProbe());
            buildable.setReadinessProbe(fluent.getReadinessProbe());
            buildable.setJvmOptions(fluent.getJvmOptions());
            buildable.setMetrics(fluent.getMetrics());
            buildable.setAffinity(fluent.getAffinity());
            buildable.setTolerations(fluent.getTolerations());
            buildable.setTemplate(fluent.getTemplate());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ZookeeperClusterSpecBuilder that = (ZookeeperClusterSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
