package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.Affinity;
import java.lang.Object;
import java.lang.Boolean;

public class TopicOperatorSpecFluentImpl<A extends TopicOperatorSpecFluent<A>> extends EntityTopicOperatorSpecFluentImpl<A> implements TopicOperatorSpecFluent<A>{

    private Affinity affinity;
    private TlsSidecarBuilder tlsSidecar;

    public TopicOperatorSpecFluentImpl(){
    }
    public TopicOperatorSpecFluentImpl(TopicOperatorSpec instance){
            this.withAffinity(instance.getAffinity());

            this.withTlsSidecar(instance.getTlsSidecar());

            this.withWatchedNamespace(instance.getWatchedNamespace());

            this.withImage(instance.getImage());

            this.withReconciliationIntervalSeconds(instance.getReconciliationIntervalSeconds());

            this.withZookeeperSessionTimeoutSeconds(instance.getZookeeperSessionTimeoutSeconds());

            this.withTopicMetadataMaxAttempts(instance.getTopicMetadataMaxAttempts());

            this.withLivenessProbe(instance.getLivenessProbe());

            this.withReadinessProbe(instance.getReadinessProbe());

            this.withResources(instance.getResources());

            this.withLogging(instance.getLogging());

            this.withJvmOptions(instance.getJvmOptions());

    }

    public Affinity getAffinity(){
            return this.affinity;
    }

    public A withAffinity(Affinity affinity){
            this.affinity=affinity; return (A) this;
    }

    public Boolean hasAffinity(){
            return this.affinity != null;
    }

    
/**
 * This method has been deprecated, please use method buildTlsSidecar instead.
 * @return The buildable object.
 */
@Deprecated public TlsSidecar getTlsSidecar(){
            return this.tlsSidecar!=null?this.tlsSidecar.build():null;
    }

    public TlsSidecar buildTlsSidecar(){
            return this.tlsSidecar!=null?this.tlsSidecar.build():null;
    }

    public A withTlsSidecar(TlsSidecar tlsSidecar){
            _visitables.get("tlsSidecar").remove(this.tlsSidecar);
            if (tlsSidecar!=null){ this.tlsSidecar= new TlsSidecarBuilder(tlsSidecar); _visitables.get("tlsSidecar").add(this.tlsSidecar);} return (A) this;
    }

    public Boolean hasTlsSidecar(){
            return this.tlsSidecar != null;
    }

    public TopicOperatorSpecFluent.TlsSidecarNested<A> withNewTlsSidecar(){
            return new TlsSidecarNestedImpl();
    }

    public TopicOperatorSpecFluent.TlsSidecarNested<A> withNewTlsSidecarLike(TlsSidecar item){
            return new TlsSidecarNestedImpl(item);
    }

    public TopicOperatorSpecFluent.TlsSidecarNested<A> editTlsSidecar(){
            return withNewTlsSidecarLike(getTlsSidecar());
    }

    public TopicOperatorSpecFluent.TlsSidecarNested<A> editOrNewTlsSidecar(){
            return withNewTlsSidecarLike(getTlsSidecar() != null ? getTlsSidecar(): new TlsSidecarBuilder().build());
    }

    public TopicOperatorSpecFluent.TlsSidecarNested<A> editOrNewTlsSidecarLike(TlsSidecar item){
            return withNewTlsSidecarLike(getTlsSidecar() != null ? getTlsSidecar(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TopicOperatorSpecFluentImpl that = (TopicOperatorSpecFluentImpl) o;
            if (affinity != null ? !affinity.equals(that.affinity) :that.affinity != null) return false;
            if (tlsSidecar != null ? !tlsSidecar.equals(that.tlsSidecar) :that.tlsSidecar != null) return false;
            return true;
    }


    public class TlsSidecarNestedImpl<N> extends TlsSidecarFluentImpl<TopicOperatorSpecFluent.TlsSidecarNested<N>> implements TopicOperatorSpecFluent.TlsSidecarNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TlsSidecarBuilder builder;
    
            TlsSidecarNestedImpl(TlsSidecar item){
                    this.builder = new TlsSidecarBuilder(this, item);
            }
            TlsSidecarNestedImpl(){
                    this.builder = new TlsSidecarBuilder(this);
            }
    
    public N and(){
            return (N) TopicOperatorSpecFluentImpl.this.withTlsSidecar(builder.build());
    }
    public N endTlsSidecar(){
            return and();
    }

}


}
