package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class TlsClientAuthenticationBuilder extends TlsClientAuthenticationFluentImpl<TlsClientAuthenticationBuilder> implements VisitableBuilder<TlsClientAuthentication,TlsClientAuthenticationBuilder>{

    TlsClientAuthenticationFluent<?> fluent;
    Boolean validationEnabled;

    public TlsClientAuthenticationBuilder(){
            this(true);
    }
    public TlsClientAuthenticationBuilder(Boolean validationEnabled){
            this(new TlsClientAuthentication(), validationEnabled);
    }
    public TlsClientAuthenticationBuilder(TlsClientAuthenticationFluent<?> fluent){
            this(fluent, true);
    }
    public TlsClientAuthenticationBuilder(TlsClientAuthenticationFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new TlsClientAuthentication(), validationEnabled);
    }
    public TlsClientAuthenticationBuilder(TlsClientAuthenticationFluent<?> fluent,TlsClientAuthentication instance){
            this(fluent, instance, true);
    }
    public TlsClientAuthenticationBuilder(TlsClientAuthenticationFluent<?> fluent,TlsClientAuthentication instance,Boolean validationEnabled){
            this.fluent = fluent; 
            this.validationEnabled = validationEnabled; 
    }
    public TlsClientAuthenticationBuilder(TlsClientAuthentication instance){
            this(instance,true);
    }
    public TlsClientAuthenticationBuilder(TlsClientAuthentication instance,Boolean validationEnabled){
            this.fluent = this; 
            this.validationEnabled = validationEnabled; 
    }

    public TlsClientAuthentication build(){
            TlsClientAuthentication buildable = new TlsClientAuthentication();
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TlsClientAuthenticationBuilder that = (TlsClientAuthenticationBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
