package io.strimzi.api.kafka.model;

import java.lang.StringBuffer;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ResourceRequirements;

public class SidecarFluentImpl<A extends SidecarFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements SidecarFluent<A>{

    private String image;
    private ResourceRequirements resources;

    public SidecarFluentImpl(){
    }
    public SidecarFluentImpl(Sidecar instance){
            this.withImage(instance.getImage());

            this.withResources(instance.getResources());

    }

    public String getImage(){
            return this.image;
    }

    public A withImage(String image){
            this.image=image; return (A) this;
    }

    public Boolean hasImage(){
            return this.image != null;
    }

    public A withNewImage(String arg1){
            return (A)withImage(new String(arg1));
    }

    public A withNewImage(StringBuilder arg1){
            return (A)withImage(new String(arg1));
    }

    public A withNewImage(StringBuffer arg1){
            return (A)withImage(new String(arg1));
    }

    public ResourceRequirements getResources(){
            return this.resources;
    }

    public A withResources(ResourceRequirements resources){
            this.resources=resources; return (A) this;
    }

    public Boolean hasResources(){
            return this.resources != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            SidecarFluentImpl that = (SidecarFluentImpl) o;
            if (image != null ? !image.equals(that.image) :that.image != null) return false;
            if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
            return true;
    }




}
