package io.strimzi.api.kafka.model;

import java.lang.StringBuffer;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class PasswordSecretSourceFluentImpl<A extends PasswordSecretSourceFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements PasswordSecretSourceFluent<A>{

    private String secretName;
    private String password;

    public PasswordSecretSourceFluentImpl(){
    }
    public PasswordSecretSourceFluentImpl(PasswordSecretSource instance){
            this.withSecretName(instance.getSecretName());

            this.withPassword(instance.getPassword());

    }

    public String getSecretName(){
            return this.secretName;
    }

    public A withSecretName(String secretName){
            this.secretName=secretName; return (A) this;
    }

    public Boolean hasSecretName(){
            return this.secretName != null;
    }

    public A withNewSecretName(String arg1){
            return (A)withSecretName(new String(arg1));
    }

    public A withNewSecretName(StringBuilder arg1){
            return (A)withSecretName(new String(arg1));
    }

    public A withNewSecretName(StringBuffer arg1){
            return (A)withSecretName(new String(arg1));
    }

    public String getPassword(){
            return this.password;
    }

    public A withPassword(String password){
            this.password=password; return (A) this;
    }

    public Boolean hasPassword(){
            return this.password != null;
    }

    public A withNewPassword(String arg1){
            return (A)withPassword(new String(arg1));
    }

    public A withNewPassword(StringBuilder arg1){
            return (A)withPassword(new String(arg1));
    }

    public A withNewPassword(StringBuffer arg1){
            return (A)withPassword(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            PasswordSecretSourceFluentImpl that = (PasswordSecretSourceFluentImpl) o;
            if (secretName != null ? !secretName.equals(that.secretName) :that.secretName != null) return false;
            if (password != null ? !password.equals(that.password) :that.password != null) return false;
            return true;
    }




}
