package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaUserTlsClientAuthenticationBuilder extends KafkaUserTlsClientAuthenticationFluentImpl<KafkaUserTlsClientAuthenticationBuilder> implements VisitableBuilder<KafkaUserTlsClientAuthentication,KafkaUserTlsClientAuthenticationBuilder>{

    KafkaUserTlsClientAuthenticationFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaUserTlsClientAuthenticationBuilder(){
            this(true);
    }
    public KafkaUserTlsClientAuthenticationBuilder(Boolean validationEnabled){
            this(new KafkaUserTlsClientAuthentication(), validationEnabled);
    }
    public KafkaUserTlsClientAuthenticationBuilder(KafkaUserTlsClientAuthenticationFluent<?> fluent){
            this(fluent, true);
    }
    public KafkaUserTlsClientAuthenticationBuilder(KafkaUserTlsClientAuthenticationFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new KafkaUserTlsClientAuthentication(), validationEnabled);
    }
    public KafkaUserTlsClientAuthenticationBuilder(KafkaUserTlsClientAuthenticationFluent<?> fluent,KafkaUserTlsClientAuthentication instance){
            this(fluent, instance, true);
    }
    public KafkaUserTlsClientAuthenticationBuilder(KafkaUserTlsClientAuthenticationFluent<?> fluent,KafkaUserTlsClientAuthentication instance,Boolean validationEnabled){
            this.fluent = fluent; 
            this.validationEnabled = validationEnabled; 
    }
    public KafkaUserTlsClientAuthenticationBuilder(KafkaUserTlsClientAuthentication instance){
            this(instance,true);
    }
    public KafkaUserTlsClientAuthenticationBuilder(KafkaUserTlsClientAuthentication instance,Boolean validationEnabled){
            this.fluent = this; 
            this.validationEnabled = validationEnabled; 
    }

    public KafkaUserTlsClientAuthentication build(){
            KafkaUserTlsClientAuthentication buildable = new KafkaUserTlsClientAuthentication();
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KafkaUserTlsClientAuthenticationBuilder that = (KafkaUserTlsClientAuthenticationBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
