package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaUserBuilder extends KafkaUserFluentImpl<KafkaUserBuilder> implements VisitableBuilder<KafkaUser,KafkaUserBuilder>{

    KafkaUserFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaUserBuilder(){
            this(true);
    }
    public KafkaUserBuilder(Boolean validationEnabled){
            this(new KafkaUser(), validationEnabled);
    }
    public KafkaUserBuilder(KafkaUserFluent<?> fluent){
            this(fluent, true);
    }
    public KafkaUserBuilder(KafkaUserFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new KafkaUser(), validationEnabled);
    }
    public KafkaUserBuilder(KafkaUserFluent<?> fluent,KafkaUser instance){
            this(fluent, instance, true);
    }
    public KafkaUserBuilder(KafkaUserFluent<?> fluent,KafkaUser instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withMetadata(instance.getMetadata());

            fluent.withSpec(instance.getSpec());

            fluent.withStatus(instance.getStatus());

            this.validationEnabled = validationEnabled; 
    }
    public KafkaUserBuilder(KafkaUser instance){
            this(instance,true);
    }
    public KafkaUserBuilder(KafkaUser instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withMetadata(instance.getMetadata());

            this.withSpec(instance.getSpec());

            this.withStatus(instance.getStatus());

            this.validationEnabled = validationEnabled; 
    }

    public KafkaUser build(){
            KafkaUser buildable = new KafkaUser();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setMetadata(fluent.getMetadata());
            buildable.setSpec(fluent.getSpec());
            buildable.setStatus(fluent.getStatus());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KafkaUserBuilder that = (KafkaUserBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
