package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaSpecBuilder extends KafkaSpecFluentImpl<KafkaSpecBuilder> implements VisitableBuilder<KafkaSpec,KafkaSpecBuilder>{

    KafkaSpecFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaSpecBuilder(){
            this(true);
    }
    public KafkaSpecBuilder(Boolean validationEnabled){
            this(new KafkaSpec(), validationEnabled);
    }
    public KafkaSpecBuilder(KafkaSpecFluent<?> fluent){
            this(fluent, true);
    }
    public KafkaSpecBuilder(KafkaSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new KafkaSpec(), validationEnabled);
    }
    public KafkaSpecBuilder(KafkaSpecFluent<?> fluent,KafkaSpec instance){
            this(fluent, instance, true);
    }
    public KafkaSpecBuilder(KafkaSpecFluent<?> fluent,KafkaSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withKafka(instance.getKafka());

            fluent.withZookeeper(instance.getZookeeper());

            fluent.withTopicOperator(instance.getTopicOperator());

            fluent.withEntityOperator(instance.getEntityOperator());

            fluent.withClusterCa(instance.getClusterCa());

            fluent.withKafkaExporter(instance.getKafkaExporter());

            fluent.withClientsCa(instance.getClientsCa());

            fluent.withMaintenanceTimeWindows(instance.getMaintenanceTimeWindows());

            this.validationEnabled = validationEnabled; 
    }
    public KafkaSpecBuilder(KafkaSpec instance){
            this(instance,true);
    }
    public KafkaSpecBuilder(KafkaSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withKafka(instance.getKafka());

            this.withZookeeper(instance.getZookeeper());

            this.withTopicOperator(instance.getTopicOperator());

            this.withEntityOperator(instance.getEntityOperator());

            this.withClusterCa(instance.getClusterCa());

            this.withKafkaExporter(instance.getKafkaExporter());

            this.withClientsCa(instance.getClientsCa());

            this.withMaintenanceTimeWindows(instance.getMaintenanceTimeWindows());

            this.validationEnabled = validationEnabled; 
    }

    public KafkaSpec build(){
            KafkaSpec buildable = new KafkaSpec();
            buildable.setKafka(fluent.getKafka());
            buildable.setZookeeper(fluent.getZookeeper());
            buildable.setTopicOperator(fluent.getTopicOperator());
            buildable.setEntityOperator(fluent.getEntityOperator());
            buildable.setClusterCa(fluent.getClusterCa());
            buildable.setKafkaExporter(fluent.getKafkaExporter());
            buildable.setClientsCa(fluent.getClientsCa());
            buildable.setMaintenanceTimeWindows(fluent.getMaintenanceTimeWindows());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KafkaSpecBuilder that = (KafkaSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
