package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaMirrorMakerTlsBuilder extends KafkaMirrorMakerTlsFluentImpl<KafkaMirrorMakerTlsBuilder> implements VisitableBuilder<KafkaMirrorMakerTls,KafkaMirrorMakerTlsBuilder>{

    KafkaMirrorMakerTlsFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaMirrorMakerTlsBuilder(){
            this(true);
    }
    public KafkaMirrorMakerTlsBuilder(Boolean validationEnabled){
            this(new KafkaMirrorMakerTls(), validationEnabled);
    }
    public KafkaMirrorMakerTlsBuilder(KafkaMirrorMakerTlsFluent<?> fluent){
            this(fluent, true);
    }
    public KafkaMirrorMakerTlsBuilder(KafkaMirrorMakerTlsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new KafkaMirrorMakerTls(), validationEnabled);
    }
    public KafkaMirrorMakerTlsBuilder(KafkaMirrorMakerTlsFluent<?> fluent,KafkaMirrorMakerTls instance){
            this(fluent, instance, true);
    }
    public KafkaMirrorMakerTlsBuilder(KafkaMirrorMakerTlsFluent<?> fluent,KafkaMirrorMakerTls instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withTrustedCertificates(instance.getTrustedCertificates());

            this.validationEnabled = validationEnabled; 
    }
    public KafkaMirrorMakerTlsBuilder(KafkaMirrorMakerTls instance){
            this(instance,true);
    }
    public KafkaMirrorMakerTlsBuilder(KafkaMirrorMakerTls instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withTrustedCertificates(instance.getTrustedCertificates());

            this.validationEnabled = validationEnabled; 
    }

    public KafkaMirrorMakerTls build(){
            KafkaMirrorMakerTls buildable = new KafkaMirrorMakerTls();
            buildable.setTrustedCertificates(fluent.getTrustedCertificates());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KafkaMirrorMakerTlsBuilder that = (KafkaMirrorMakerTlsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
