package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaMirrorMakerSpecBuilder extends KafkaMirrorMakerSpecFluentImpl<KafkaMirrorMakerSpecBuilder> implements VisitableBuilder<KafkaMirrorMakerSpec,KafkaMirrorMakerSpecBuilder>{

    KafkaMirrorMakerSpecFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaMirrorMakerSpecBuilder(){
            this(true);
    }
    public KafkaMirrorMakerSpecBuilder(Boolean validationEnabled){
            this(new KafkaMirrorMakerSpec(), validationEnabled);
    }
    public KafkaMirrorMakerSpecBuilder(KafkaMirrorMakerSpecFluent<?> fluent){
            this(fluent, true);
    }
    public KafkaMirrorMakerSpecBuilder(KafkaMirrorMakerSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new KafkaMirrorMakerSpec(), validationEnabled);
    }
    public KafkaMirrorMakerSpecBuilder(KafkaMirrorMakerSpecFluent<?> fluent,KafkaMirrorMakerSpec instance){
            this(fluent, instance, true);
    }
    public KafkaMirrorMakerSpecBuilder(KafkaMirrorMakerSpecFluent<?> fluent,KafkaMirrorMakerSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withReplicas(instance.getReplicas());

            fluent.withVersion(instance.getVersion());

            fluent.withImage(instance.getImage());

            fluent.withWhitelist(instance.getWhitelist());

            fluent.withConsumer(instance.getConsumer());

            fluent.withProducer(instance.getProducer());

            fluent.withResources(instance.getResources());

            fluent.withLivenessProbe(instance.getLivenessProbe());

            fluent.withReadinessProbe(instance.getReadinessProbe());

            fluent.withAffinity(instance.getAffinity());

            fluent.withTolerations(instance.getTolerations());

            fluent.withJvmOptions(instance.getJvmOptions());

            fluent.withLogging(instance.getLogging());

            fluent.withMetrics(instance.getMetrics());

            fluent.withTracing(instance.getTracing());

            fluent.withTemplate(instance.getTemplate());

            this.validationEnabled = validationEnabled; 
    }
    public KafkaMirrorMakerSpecBuilder(KafkaMirrorMakerSpec instance){
            this(instance,true);
    }
    public KafkaMirrorMakerSpecBuilder(KafkaMirrorMakerSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withReplicas(instance.getReplicas());

            this.withVersion(instance.getVersion());

            this.withImage(instance.getImage());

            this.withWhitelist(instance.getWhitelist());

            this.withConsumer(instance.getConsumer());

            this.withProducer(instance.getProducer());

            this.withResources(instance.getResources());

            this.withLivenessProbe(instance.getLivenessProbe());

            this.withReadinessProbe(instance.getReadinessProbe());

            this.withAffinity(instance.getAffinity());

            this.withTolerations(instance.getTolerations());

            this.withJvmOptions(instance.getJvmOptions());

            this.withLogging(instance.getLogging());

            this.withMetrics(instance.getMetrics());

            this.withTracing(instance.getTracing());

            this.withTemplate(instance.getTemplate());

            this.validationEnabled = validationEnabled; 
    }

    public KafkaMirrorMakerSpec build(){
            KafkaMirrorMakerSpec buildable = new KafkaMirrorMakerSpec();
            buildable.setReplicas(fluent.getReplicas());
            buildable.setVersion(fluent.getVersion());
            buildable.setImage(fluent.getImage());
            buildable.setWhitelist(fluent.getWhitelist());
            buildable.setConsumer(fluent.getConsumer());
            buildable.setProducer(fluent.getProducer());
            buildable.setResources(fluent.getResources());
            buildable.setLivenessProbe(fluent.getLivenessProbe());
            buildable.setReadinessProbe(fluent.getReadinessProbe());
            buildable.setAffinity(fluent.getAffinity());
            buildable.setTolerations(fluent.getTolerations());
            buildable.setJvmOptions(fluent.getJvmOptions());
            buildable.setLogging(fluent.getLogging());
            buildable.setMetrics(fluent.getMetrics());
            buildable.setTracing(fluent.getTracing());
            buildable.setTemplate(fluent.getTemplate());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KafkaMirrorMakerSpecBuilder that = (KafkaMirrorMakerSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
