package io.strimzi.api.kafka.model;

import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class KafkaMirrorMakerProducerSpecFluentImpl<A extends KafkaMirrorMakerProducerSpecFluent<A>> extends KafkaMirrorMakerClientSpecFluentImpl<A> implements KafkaMirrorMakerProducerSpecFluent<A>{

    private Boolean abortOnSendFailure;

    public KafkaMirrorMakerProducerSpecFluentImpl(){
    }
    public KafkaMirrorMakerProducerSpecFluentImpl(KafkaMirrorMakerProducerSpec instance){
            this.withAbortOnSendFailure(instance.getAbortOnSendFailure());

            this.withBootstrapServers(instance.getBootstrapServers());

            this.withConfig(instance.getConfig());

            this.withTls(instance.getTls());

            this.withAuthentication(instance.getAuthentication());

    }

    public Boolean isAbortOnSendFailure(){
            return this.abortOnSendFailure;
    }

    public A withAbortOnSendFailure(Boolean abortOnSendFailure){
            this.abortOnSendFailure=abortOnSendFailure; return (A) this;
    }

    public Boolean hasAbortOnSendFailure(){
            return this.abortOnSendFailure != null;
    }

    public A withNewAbortOnSendFailure(String arg1){
            return (A)withAbortOnSendFailure(new Boolean(arg1));
    }

    public A withNewAbortOnSendFailure(boolean arg1){
            return (A)withAbortOnSendFailure(new Boolean(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KafkaMirrorMakerProducerSpecFluentImpl that = (KafkaMirrorMakerProducerSpecFluentImpl) o;
            if (abortOnSendFailure != null ? !abortOnSendFailure.equals(that.abortOnSendFailure) :that.abortOnSendFailure != null) return false;
            return true;
    }




}
