package io.strimzi.api.kafka.model;

import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;

public class KafkaConnectorSpecFluentImpl<A extends KafkaConnectorSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements KafkaConnectorSpecFluent<A>{

    private String className;
    private Integer tasksMax;
    private Boolean pause;
    private Map<String,Object> config;

    public KafkaConnectorSpecFluentImpl(){
    }
    public KafkaConnectorSpecFluentImpl(KafkaConnectorSpec instance){
            this.withClassName(instance.getClassName());

            this.withTasksMax(instance.getTasksMax());

            this.withPause(instance.getPause());

            this.withConfig(instance.getConfig());

    }

    public String getClassName(){
            return this.className;
    }

    public A withClassName(String className){
            this.className=className; return (A) this;
    }

    public Boolean hasClassName(){
            return this.className != null;
    }

    public A withNewClassName(String arg1){
            return (A)withClassName(new String(arg1));
    }

    public A withNewClassName(StringBuilder arg1){
            return (A)withClassName(new String(arg1));
    }

    public A withNewClassName(StringBuffer arg1){
            return (A)withClassName(new String(arg1));
    }

    public Integer getTasksMax(){
            return this.tasksMax;
    }

    public A withTasksMax(Integer tasksMax){
            this.tasksMax=tasksMax; return (A) this;
    }

    public Boolean hasTasksMax(){
            return this.tasksMax != null;
    }

    public Boolean isPause(){
            return this.pause;
    }

    public A withPause(Boolean pause){
            this.pause=pause; return (A) this;
    }

    public Boolean hasPause(){
            return this.pause != null;
    }

    public A withNewPause(String arg1){
            return (A)withPause(new Boolean(arg1));
    }

    public A withNewPause(boolean arg1){
            return (A)withPause(new Boolean(arg1));
    }

    public A addToConfig(String key,Object value){
            if(this.config == null && key != null && value != null) { this.config = new LinkedHashMap<String,Object>(); }
            if(key != null && value != null) {this.config.put(key, value);} return (A)this;
    }

    public A addToConfig(Map<String,Object> map){
            if(this.config == null && map != null) { this.config = new LinkedHashMap<String,Object>(); }
            if(map != null) { this.config.putAll(map);} return (A)this;
    }

    public A removeFromConfig(String key){
            if(this.config == null) { return (A) this; }
            if(key != null && this.config != null) {this.config.remove(key);} return (A)this;
    }

    public A removeFromConfig(Map<String,Object> map){
            if(this.config == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.config != null){this.config.remove(key);}}} return (A)this;
    }

    public Map<String,Object> getConfig(){
            return this.config;
    }

    public A withConfig(Map<String,Object> config){
            if (config == null) { this.config =  null;} else {this.config = new LinkedHashMap<String,Object>(config);} return (A) this;
    }

    public Boolean hasConfig(){
            return this.config != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            KafkaConnectorSpecFluentImpl that = (KafkaConnectorSpecFluentImpl) o;
            if (className != null ? !className.equals(that.className) :that.className != null) return false;
            if (tasksMax != null ? !tasksMax.equals(that.tasksMax) :that.tasksMax != null) return false;
            if (pause != null ? !pause.equals(that.pause) :that.pause != null) return false;
            if (config != null ? !config.equals(that.config) :that.config != null) return false;
            return true;
    }




}
