package io.strimzi.api.kafka.model;

import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;

public interface KafkaConnectorSpecFluent<A extends KafkaConnectorSpecFluent<A>> extends Fluent<A>{


    public String getClassName();
    public A withClassName(String className);
    public Boolean hasClassName();
    public A withNewClassName(String arg1);
    public A withNewClassName(StringBuilder arg1);
    public A withNewClassName(StringBuffer arg1);
    public Integer getTasksMax();
    public A withTasksMax(Integer tasksMax);
    public Boolean hasTasksMax();
    public Boolean isPause();
    public A withPause(Boolean pause);
    public Boolean hasPause();
    public A withNewPause(String arg1);
    public A withNewPause(boolean arg1);
    public A addToConfig(String key,Object value);
    public A addToConfig(Map<String,Object> map);
    public A removeFromConfig(String key);
    public A removeFromConfig(Map<String,Object> map);
    public Map<String,Object> getConfig();
    public A withConfig(Map<String,Object> config);
    public Boolean hasConfig();



}
