package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaConnectorSpecBuilder extends KafkaConnectorSpecFluentImpl<KafkaConnectorSpecBuilder> implements VisitableBuilder<KafkaConnectorSpec,KafkaConnectorSpecBuilder>{

    KafkaConnectorSpecFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaConnectorSpecBuilder(){
            this(true);
    }
    public KafkaConnectorSpecBuilder(Boolean validationEnabled){
            this(new KafkaConnectorSpec(), validationEnabled);
    }
    public KafkaConnectorSpecBuilder(KafkaConnectorSpecFluent<?> fluent){
            this(fluent, true);
    }
    public KafkaConnectorSpecBuilder(KafkaConnectorSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new KafkaConnectorSpec(), validationEnabled);
    }
    public KafkaConnectorSpecBuilder(KafkaConnectorSpecFluent<?> fluent,KafkaConnectorSpec instance){
            this(fluent, instance, true);
    }
    public KafkaConnectorSpecBuilder(KafkaConnectorSpecFluent<?> fluent,KafkaConnectorSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withClassName(instance.getClassName());

            fluent.withTasksMax(instance.getTasksMax());

            fluent.withPause(instance.getPause());

            fluent.withConfig(instance.getConfig());

            this.validationEnabled = validationEnabled; 
    }
    public KafkaConnectorSpecBuilder(KafkaConnectorSpec instance){
            this(instance,true);
    }
    public KafkaConnectorSpecBuilder(KafkaConnectorSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withClassName(instance.getClassName());

            this.withTasksMax(instance.getTasksMax());

            this.withPause(instance.getPause());

            this.withConfig(instance.getConfig());

            this.validationEnabled = validationEnabled; 
    }

    public KafkaConnectorSpec build(){
            KafkaConnectorSpec buildable = new KafkaConnectorSpec();
            buildable.setClassName(fluent.getClassName());
            buildable.setTasksMax(fluent.getTasksMax());
            buildable.setPause(fluent.isPause());
            buildable.setConfig(fluent.getConfig());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KafkaConnectorSpecBuilder that = (KafkaConnectorSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
